/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/ImageDevCppExports.h>
#include <memory>

namespace imagedev {

/// This attribute manages two-dimensional measurements belonging to the Feret category of native measurements.
class IMAGEDEV_CPP_API Feret2d
{
public:
    typedef std::shared_ptr< Feret2d > Ptr;

    /// Internal constructor
    Feret2d(){};

    /// Sets the number of Feret angles and updates the angle distribution.
    void setOrientationCount( uint64_t number );
    /// Returns the number of Feret angles.
    uint64_t orientationCount() const;

    /// Sets a new angle in degrees, between 0 and 360, at the index position of the Feret distribution.
    void setOrientation( uint64_t index, float angle );
    /// Returns the angle value in degrees at the index position in the distribution.
    float orientation( uint64_t index ) const;

    /// Recomputes the orientations from the current number of angles in order to have a uniform distribution
    /// around a half circle.
    void resample();
};

} // namespace imagedev
