/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/ImageDevCppExports.h>
#include <memory>

namespace imagedev {

/// This attribute defines the neighborhood of a particles with the NeighborCount measurement.
class IMAGEDEV_CPP_API NeighborCount
{
public:
    typedef std::shared_ptr< NeighborCount > Ptr;

    /// Internal constructor
    NeighborCount(){};

    /// Makes the maximum distance interpreted in world units (true) or in voxel units (false).
    void setCalibrated( bool calibrated );
    /// Returns true if the maximum distance is expressed in world units, false it is in voxel units.
    bool isCalibrated() const;

    /// Sets the maximum distance from the object boundaries to consider potential neighbors.
    void setMaxDistance( float distance );
    /// Returns the maximum distance from the object boundaries to consider potential neighbors.
    float maxDistance() const;

    /// Sets the minimum particle volume percentage included in the spherical neighborhood to select a potential
    /// neighbor.
    void setMinOverlap( float overlap );
    /// Returns the minimum particle volume percentage included in the spherical neighborhood to select a potential
    /// neighbor.
    float minOverlap() const;
};

} // namespace imagedev
