/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Data/AnalysisMeasurements/Measurement.h>

namespace imagedev
{
namespace measurements
{

/// The minimal extent of the data in the direction of the smallest eigenvector of the covariance matrix. This value is only available in 3D.
class IMAGEDEV_CPP_API ExtentMin3 : public Measurement
{
public:
    typedef std::shared_ptr< ExtentMin3 > Ptr;

    /// Constructor
    ExtentMin3( object_model::DynamicDictionary* object );
    /// @copydoc imagedev::measurements::Measurement::name()
    std::string name() const override;
    /// @copydoc imagedev::measurements::Measurement::physDim()
    std::string physDim() const override;
    /// Gets a result of the measurement.
    /// @returns The minimal extent of the data in the direction of the smallest eigenvector of the covariance matrix. This value is only available in 3D.
    double value( size_t label = 0 );
    /// Gets the size of the measurement result
    size_t size();
};

}
} // namespace imagedev
