/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/ImageDevCppExports.h>
#include <iolink/Vector.h>
#include <iolink/view/DataFrameView.h>
#include <ImageDev/Data/MeasurementInformation/FieldInformation.h>
#include <ImageDev/Data/MeasurementInformation/PhysicalDimension.h>
#include <memory>
#include <vector>

namespace object_model
{
class Dictionary;
}

namespace imagedev
{
struct AxisPropagationDistance3dMsrPrivate;

/// Contains the results of a propagation distance analysis performed on a three-dimensional image.
/// This object is generated by the imagedev::AxisPropagationDistance3d algorithm and the imagedev::axisPropagationDistance3d function.
class IMAGEDEV_CPP_API AxisPropagationDistance3dMsr
{
public:
    typedef AxisPropagationDistance3dMsr Self;
    typedef std::shared_ptr< Self > Ptr;

    /// Default destructor
    ~AxisPropagationDistance3dMsr();

    /// Writes the AxisPropagationDistance3dMsr measurement into a file defined by a path.
    /// @param pathName Path of a file
    void write( const std::string& pathName ) const;
    /// Reads the AxisPropagationDistance3dMsr measurement from a file defined by a path.
    /// @param pathName Path of a file
    /// @return The AxisPropagationDistance3dMsr measurement read.
    static AxisPropagationDistance3dMsr::Ptr read( const std::string& pathName );

    /// Returns the size of the measurement
    int64_t size() const;

    /// Converts the measurement to an IOLink.DataFrame
    std::shared_ptr< iolink::DataFrameView > toDataFrame() const;

    /// Gets a result of the isVolumePierced measurement.
    bool isVolumePierced(  ) const;
    const FieldInformation & isVolumePiercedInformation() const;

    /// Gets a result of the voidThickness measurement.
    double voidThickness(  ) const;
    const FieldInformation & voidThicknessInformation() const;

    /// Gets a result of the voidThicknessInVoxel measurement.
    double voidThicknessInVoxel(  ) const;
    const FieldInformation & voidThicknessInVoxelInformation() const;

    /// Gets a result of the voidToVolumeThickness measurement.
    double voidToVolumeThickness(  ) const;
    const FieldInformation & voidToVolumeThicknessInformation() const;

    /// Gets a result of the shortestDistance measurement.
    double shortestDistance(  ) const;
    const FieldInformation & shortestDistanceInformation() const;

    /// Gets a result of the shortestDistanceInVoxel measurement.
    double shortestDistanceInVoxel(  ) const;
    const FieldInformation & shortestDistanceInVoxelInformation() const;

    /// Gets a result of the shortestDistanceToVolumeThickness measurement.
    double shortestDistanceToVolumeThickness(  ) const;
    const FieldInformation & shortestDistanceToVolumeThicknessInformation() const;

    /// Gets a result of the maximumDistance measurement.
    double maximumDistance(  ) const;
    const FieldInformation & maximumDistanceInformation() const;

    /// Gets a result of the maximumDistanceInVoxel measurement.
    double maximumDistanceInVoxel(  ) const;
    const FieldInformation & maximumDistanceInVoxelInformation() const;

private:
    friend struct AxisPropagationDistance3dMsrPrivate;
    AxisPropagationDistance3dMsr( object_model::Dictionary* );
    AxisPropagationDistance3dMsrPrivate* m_p;
};

} // namespace imagedev
