/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/ImageDevCppExports.h>
#include <iolink/Vector.h>
#include <iolink/view/DataFrameView.h>
#include <ImageDev/Data/MeasurementInformation/FieldInformation.h>
#include <ImageDev/Data/MeasurementInformation/PhysicalDimension.h>
#include <memory>
#include <vector>

namespace object_model
{
class Dictionary;
}

namespace imagedev
{
struct AxisPropagationLabel3dMsrPrivate;

/// Contains the results of a label propagation analysis performed on a three-dimensional image.
/// This object is generated by the imagedev::AxisPropagationLabel3d algorithm and the imagedev::axisPropagationLabel3d function.
class IMAGEDEV_CPP_API AxisPropagationLabel3dMsr
{
public:
    typedef AxisPropagationLabel3dMsr Self;
    typedef std::shared_ptr< Self > Ptr;

    /// Default destructor
    ~AxisPropagationLabel3dMsr();

    /// Writes the AxisPropagationLabel3dMsr measurement into a file defined by a path.
    /// @param pathName Path of a file
    void write( const std::string& pathName ) const;
    /// Reads the AxisPropagationLabel3dMsr measurement from a file defined by a path.
    /// @param pathName Path of a file
    /// @return The AxisPropagationLabel3dMsr measurement read.
    static AxisPropagationLabel3dMsr::Ptr read( const std::string& pathName );

    /// Returns the size of the measurement
    int64_t size() const;

    /// Converts the measurement to an IOLink.DataFrame
    std::shared_ptr< iolink::DataFrameView > toDataFrame() const;

    /// Gets a result of the poreVolume measurement.
    double poreVolume(  ) const;
    const FieldInformation & poreVolumeInformation() const;

    /// Gets a result of the connectedPoreVolume measurement.
    double connectedPoreVolume(  ) const;
    const FieldInformation & connectedPoreVolumeInformation() const;

    /// Gets a result of the isolatedPoreVolume measurement.
    double isolatedPoreVolume(  ) const;
    const FieldInformation & isolatedPoreVolumeInformation() const;

    /// Gets a result of the connectivity measurement.
    double connectivity(  ) const;
    const FieldInformation & connectivityInformation() const;

    /// Gets a result of the connectedPoreMean measurement.
    double connectedPoreMean(  ) const;
    const FieldInformation & connectedPoreMeanInformation() const;

    /// Gets a result of the connectedPoreStdDev measurement.
    double connectedPoreStdDev(  ) const;
    const FieldInformation & connectedPoreStdDevInformation() const;

    /// Gets a result of the isolatedPoreMean measurement.
    double isolatedPoreMean(  ) const;
    const FieldInformation & isolatedPoreMeanInformation() const;

    /// Gets a result of the isolatedPoreStdDev measurement.
    double isolatedPoreStdDev(  ) const;
    const FieldInformation & isolatedPoreStdDevInformation() const;

private:
    friend struct AxisPropagationLabel3dMsrPrivate;
    AxisPropagationLabel3dMsr( object_model::Dictionary* );
    AxisPropagationLabel3dMsrPrivate* m_p;
};

} // namespace imagedev
