/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/ImageDevCppExports.h>
#include <iolink/Vector.h>
#include <iolink/view/DataFrameView.h>
#include <ImageDev/Data/MeasurementInformation/FieldInformation.h>
#include <ImageDev/Data/MeasurementInformation/PhysicalDimension.h>
#include <memory>
#include <vector>

namespace object_model
{
class Dictionary;
}

namespace imagedev
{
struct Euler2dMsrPrivate;

/// Contains the connectivity number computed in a 2D binary image.
/// This object is generated by the imagedev::Euler2d algorithm and the imagedev::euler2d function.
class IMAGEDEV_CPP_API Euler2dMsr
{
public:
    typedef Euler2dMsr Self;
    typedef std::shared_ptr< Self > Ptr;

    /// Default destructor
    ~Euler2dMsr();

    /// Writes the Euler2dMsr measurement into a file defined by a path.
    /// @param pathName Path of a file
    void write( const std::string& pathName ) const;
    /// Reads the Euler2dMsr measurement from a file defined by a path.
    /// @param pathName Path of a file
    /// @return The Euler2dMsr measurement read.
    static Euler2dMsr::Ptr read( const std::string& pathName );

    /// Returns the size of the measurement
    int64_t size() const;

    /// Converts the measurement to an IOLink.DataFrame
    std::shared_ptr< iolink::DataFrameView > toDataFrame() const;

    /// Gets a result of the eulerNumber measurement.
    int64_t eulerNumber( size_t time = 0 ) const;
    const FieldInformation & eulerNumberInformation() const;

private:
    friend struct Euler2dMsrPrivate;
    Euler2dMsr( object_model::Dictionary* );
    Euler2dMsrPrivate* m_p;
};

} // namespace imagedev
