/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/ImageDevCppExports.h>
#include <iolink/Vector.h>
#include <iolink/view/DataFrameView.h>
#include <ImageDev/Data/MeasurementInformation/FieldInformation.h>
#include <ImageDev/Data/MeasurementInformation/PhysicalDimension.h>
#include <memory>
#include <vector>

namespace object_model
{
class Dictionary;
}

namespace imagedev
{
struct MomentsOfInertia3dMsrPrivate;

/// Contains the features related to the covariance matrix of a three-dimensional image.
/// This object is generated by the imagedev::MomentsOfInertia3d algorithm and the imagedev::momentsOfInertia3d function.
class IMAGEDEV_CPP_API MomentsOfInertia3dMsr
{
public:
    typedef MomentsOfInertia3dMsr Self;
    typedef std::shared_ptr< Self > Ptr;

    /// Default destructor
    ~MomentsOfInertia3dMsr();

    /// Writes the MomentsOfInertia3dMsr measurement into a file defined by a path.
    /// @param pathName Path of a file
    void write( const std::string& pathName ) const;
    /// Reads the MomentsOfInertia3dMsr measurement from a file defined by a path.
    /// @param pathName Path of a file
    /// @return The MomentsOfInertia3dMsr measurement read.
    static MomentsOfInertia3dMsr::Ptr read( const std::string& pathName );

    /// Returns the size of the measurement
    int64_t size() const;

    /// Converts the measurement to an IOLink.DataFrame
    std::shared_ptr< iolink::DataFrameView > toDataFrame() const;

    /// Gets a result of the momentXX measurement.
    double momentXX(  ) const;
    const FieldInformation & momentXXInformation() const;

    /// Gets a result of the momentYY measurement.
    double momentYY(  ) const;
    const FieldInformation & momentYYInformation() const;

    /// Gets a result of the momentZZ measurement.
    double momentZZ(  ) const;
    const FieldInformation & momentZZInformation() const;

    /// Gets a result of the momentXY measurement.
    double momentXY(  ) const;
    const FieldInformation & momentXYInformation() const;

    /// Gets a result of the momentXZ measurement.
    double momentXZ(  ) const;
    const FieldInformation & momentXZInformation() const;

    /// Gets a result of the momentYZ measurement.
    double momentYZ(  ) const;
    const FieldInformation & momentYZInformation() const;

    /// Gets a result of the orientation1Theta measurement.
    double orientation1Theta(  ) const;
    const FieldInformation & orientation1ThetaInformation() const;

    /// Gets a result of the orientation1Phi measurement.
    double orientation1Phi(  ) const;
    const FieldInformation & orientation1PhiInformation() const;

    /// Gets a result of the orientation2Theta measurement.
    double orientation2Theta(  ) const;
    const FieldInformation & orientation2ThetaInformation() const;

    /// Gets a result of the orientation2Phi measurement.
    double orientation2Phi(  ) const;
    const FieldInformation & orientation2PhiInformation() const;

private:
    friend struct MomentsOfInertia3dMsrPrivate;
    MomentsOfInertia3dMsr( object_model::Dictionary* );
    MomentsOfInertia3dMsrPrivate* m_p;
};

} // namespace imagedev
