/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Computes the maximum between the absolute values of two images.
class IMAGEDEV_CPP_API AbsoluteMaximumWithImage final : public GenericAlgorithm
{
public:

    // Command constructor.
    AbsoluteMaximumWithImage();


    /// Gets the inputImage1 parameter.
    /// The first input image.
    std::shared_ptr< iolink::ImageView > inputImage1() const;
    /// Sets the inputImage1 parameter.
    /// The first input image.
    void setInputImage1( std::shared_ptr< iolink::ImageView > inputImage1 );

    /// Gets the inputImage2 parameter.
    /// The second input image.
    std::shared_ptr< iolink::ImageView > inputImage2() const;
    /// Sets the inputImage2 parameter.
    /// The second input image.
    void setInputImage2( std::shared_ptr< iolink::ImageView > inputImage2 );

    /// Gets the outputImage parameter.
    /// The output image. Its size is the minimum between both inputs for each dimension. Its type is forced to the one having the greater capacity between both input types.
    std::shared_ptr< iolink::ImageView > outputImage() const;
    /// Sets the outputImage parameter.
    /// The output image. Its size is the minimum between both inputs for each dimension. Its type is forced to the one having the greater capacity between both input types.
    void setOutputImage( std::shared_ptr< iolink::ImageView > outputImage );

    // Method to launch the command.
    void execute();

};

/// Computes the maximum between the absolute values of two images.
/// @param inputImage1 The first input image.
/// @param inputImage2 The second input image.
/// @param outputImage The output image. Its size is the minimum between both inputs for each dimension. Its type is forced to the one having the greater capacity between both input types.
/// @return Returns the outputImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
absoluteMaximumWithImage( std::shared_ptr< iolink::ImageView > inputImage1,
                          std::shared_ptr< iolink::ImageView > inputImage2,
                          std::shared_ptr< iolink::ImageView > outputImage = nullptr );
} // namespace imagedev
