/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Shifts the intensities of an image by a given number of bits.
class IMAGEDEV_CPP_API BitShift final : public GenericAlgorithm
{
public:
    /// The shifting direction.
    enum ShiftDirection
    {
    /// The bits are shifted from the right to the left, thus output intensities are greater than input intensities.
        LEFT = 0,
    /// The bits are shifted from the left to the right, thus output intensities are lower than input intensities.
        RIGHT
    };

    // Command constructor.
    BitShift();


    /// Gets the inputImage parameter.
    /// The input image.
    std::shared_ptr< iolink::ImageView > inputImage() const;
    /// Sets the inputImage parameter.
    /// The input image.
    void setInputImage( std::shared_ptr< iolink::ImageView > inputImage );

    /// Gets the bitNumber parameter.
    /// The number of bits to shift.
    int32_t bitNumber() const;
    /// Sets the bitNumber parameter.
    /// The number of bits to shift.
    void setBitNumber( const int32_t& bitNumber );

    /// Gets the shiftDirection parameter.
    /// The shifting direction.
    BitShift::ShiftDirection shiftDirection() const;
    /// Sets the shiftDirection parameter.
    /// The shifting direction.
    void setShiftDirection( const BitShift::ShiftDirection& shiftDirection );

    /// Gets the outputImage parameter.
    /// The output image, size and type are forced to the same values as the input.
    std::shared_ptr< iolink::ImageView > outputImage() const;
    /// Sets the outputImage parameter.
    /// The output image, size and type are forced to the same values as the input.
    void setOutputImage( std::shared_ptr< iolink::ImageView > outputImage );

    // Method to launch the command.
    void execute();

};

/// Shifts the intensities of an image by a given number of bits.
/// @param inputImage The input image.
/// @param bitNumber The number of bits to shift.
/// @param shiftDirection The shifting direction.
/// @param outputImage The output image, size and type are forced to the same values as the input.
/// @return Returns the outputImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
bitShift( std::shared_ptr< iolink::ImageView > inputImage,
          int32_t bitNumber,
          BitShift::ShiftDirection shiftDirection,
          std::shared_ptr< iolink::ImageView > outputImage = nullptr );
} // namespace imagedev
