/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Smooths an image using a box kernel.
class IMAGEDEV_CPP_API BoxFilter3d final : public GenericAlgorithm
{
public:
    /// The automatic intensity scaling mode.
    enum AutoScale
    {
    /// The result is not normalized; it corresponds to the sum of the window elements.
        NO = 0,
    /// The result is automatically normalized by the number of elements of the kernel; it corresponds to the mean of the window elements.
        YES
    };

    // Command constructor.
    BoxFilter3d();


    /// Gets the inputImage parameter.
    /// The input image.
    std::shared_ptr< iolink::ImageView > inputImage() const;
    /// Sets the inputImage parameter.
    /// The input image.
    void setInputImage( std::shared_ptr< iolink::ImageView > inputImage );

    /// Gets the kernelSizeX parameter.
    /// The horizontal kernel size.
    int32_t kernelSizeX() const;
    /// Sets the kernelSizeX parameter.
    /// The horizontal kernel size.
    void setKernelSizeX( const int32_t& kernelSizeX );

    /// Gets the kernelSizeY parameter.
    /// The vertical kernel size.
    int32_t kernelSizeY() const;
    /// Sets the kernelSizeY parameter.
    /// The vertical kernel size.
    void setKernelSizeY( const int32_t& kernelSizeY );

    /// Gets the kernelSizeZ parameter.
    /// The depth kernel size.
    int32_t kernelSizeZ() const;
    /// Sets the kernelSizeZ parameter.
    /// The depth kernel size.
    void setKernelSizeZ( const int32_t& kernelSizeZ );

    /// Gets the autoScale parameter.
    /// The automatic intensity scaling mode.
    BoxFilter3d::AutoScale autoScale() const;
    /// Sets the autoScale parameter.
    /// The automatic intensity scaling mode.
    void setAutoScale( const BoxFilter3d::AutoScale& autoScale );

    /// Gets the outputImage parameter.
    /// The output image. Its dimensions are forced to the same values as the input. Its type is the same as the input if the normalization is set to yes, else the type is upgraded.
    std::shared_ptr< iolink::ImageView > outputImage() const;
    /// Sets the outputImage parameter.
    /// The output image. Its dimensions are forced to the same values as the input. Its type is the same as the input if the normalization is set to yes, else the type is upgraded.
    void setOutputImage( std::shared_ptr< iolink::ImageView > outputImage );

    // Method to launch the command.
    void execute();

};

/// Smooths an image using a box kernel.
/// @param inputImage The input image.
/// @param kernelSizeX The horizontal kernel size.
/// @param kernelSizeY The vertical kernel size.
/// @param kernelSizeZ The depth kernel size.
/// @param autoScale The automatic intensity scaling mode.
/// @param outputImage The output image. Its dimensions are forced to the same values as the input. Its type is the same as the input if the normalization is set to yes, else the type is upgraded.
/// @return Returns the outputImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
boxFilter3d( std::shared_ptr< iolink::ImageView > inputImage,
             int32_t kernelSizeX,
             int32_t kernelSizeY,
             int32_t kernelSizeZ,
             BoxFilter3d::AutoScale autoScale,
             std::shared_ptr< iolink::ImageView > outputImage = nullptr );
} // namespace imagedev
