/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
// Output structure of the cartesianToPolar2d function.
struct CartesianToPolar2dOutput
{
    /// The output modulus image. Its dimensions and type are forced to the same values as the input.
    std::shared_ptr< iolink::ImageView > outputModulusImage;
    /// The output phase image. Its dimensions and type are forced to the same values as the input.
    std::shared_ptr< iolink::ImageView > outputPhaseImage;
};

/// Transforms a pair of real and imaginary part two-dimensional images into a pair of module and phase images.
class IMAGEDEV_CPP_API CartesianToPolar2d final : public GenericAlgorithm
{
public:

    // Command constructor.
    CartesianToPolar2d();


    /// Gets the inputRealImage parameter.
    /// The real part input image. It must be a floating point image.
    std::shared_ptr< iolink::ImageView > inputRealImage() const;
    /// Sets the inputRealImage parameter.
    /// The real part input image. It must be a floating point image.
    void setInputRealImage( std::shared_ptr< iolink::ImageView > inputRealImage );

    /// Gets the inputImaginaryImage parameter.
    /// The imaginary part input image. This image must have same dimensions and data type as the real input image.
    std::shared_ptr< iolink::ImageView > inputImaginaryImage() const;
    /// Sets the inputImaginaryImage parameter.
    /// The imaginary part input image. This image must have same dimensions and data type as the real input image.
    void setInputImaginaryImage( std::shared_ptr< iolink::ImageView > inputImaginaryImage );

    /// Gets the outputModulusImage parameter.
    /// The output modulus image. Its dimensions and type are forced to the same values as the input.
    std::shared_ptr< iolink::ImageView > outputModulusImage() const;
    /// Sets the outputModulusImage parameter.
    /// The output modulus image. Its dimensions and type are forced to the same values as the input.
    void setOutputModulusImage( std::shared_ptr< iolink::ImageView > outputModulusImage );

    /// Gets the outputPhaseImage parameter.
    /// The output phase image. Its dimensions and type are forced to the same values as the input.
    std::shared_ptr< iolink::ImageView > outputPhaseImage() const;
    /// Sets the outputPhaseImage parameter.
    /// The output phase image. Its dimensions and type are forced to the same values as the input.
    void setOutputPhaseImage( std::shared_ptr< iolink::ImageView > outputPhaseImage );

    // Method to launch the command.
    void execute();

};

/// Transforms a pair of real and imaginary part two-dimensional images into a pair of module and phase images.
/// @param inputRealImage The real part input image. It must be a floating point image.
/// @param inputImaginaryImage The imaginary part input image. This image must have same dimensions and data type as the real input image.
/// @param outputModulusImage The output modulus image. Its dimensions and type are forced to the same values as the input.
/// @param outputPhaseImage The output phase image. Its dimensions and type are forced to the same values as the input.
/// @return Returns a CartesianToPolar2dOutput structure containing the outputModulusImage and outputPhaseImage output parameters.
IMAGEDEV_CPP_API 
CartesianToPolar2dOutput
cartesianToPolar2d( std::shared_ptr< iolink::ImageView > inputRealImage,
                    std::shared_ptr< iolink::ImageView > inputImaginaryImage,
                    std::shared_ptr< iolink::ImageView > outputModulusImage = nullptr,
                    std::shared_ptr< iolink::ImageView > outputPhaseImage = nullptr );
} // namespace imagedev
