/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Reduces color artifacts with a demosaicing algorithm.
class IMAGEDEV_CPP_API ColorAntialiasing2d final : public GenericAlgorithm
{
public:

    // Command constructor.
    ColorAntialiasing2d();


    /// Gets the inputColorImage parameter.
    /// The color input image.
    std::shared_ptr< iolink::ImageView > inputColorImage() const;
    /// Sets the inputColorImage parameter.
    /// The color input image.
    void setInputColorImage( std::shared_ptr< iolink::ImageView > inputColorImage );

    /// Gets the kernelSize parameter.
    /// The size of the kernel (the side in pixels of the square window).
    int32_t kernelSize() const;
    /// Sets the kernelSize parameter.
    /// The size of the kernel (the side in pixels of the square window).
    void setKernelSize( const int32_t& kernelSize );

    /// Gets the numberOfIterations parameter.
    /// The number of iterations of the demosaicing process (must be a positive integer).
    int32_t numberOfIterations() const;
    /// Sets the numberOfIterations parameter.
    /// The number of iterations of the demosaicing process (must be a positive integer).
    void setNumberOfIterations( const int32_t& numberOfIterations );

    /// Gets the outputColorImage parameter.
    /// The color output image. Its dimensions and type are forced to the same values as the input.
    std::shared_ptr< iolink::ImageView > outputColorImage() const;
    /// Sets the outputColorImage parameter.
    /// The color output image. Its dimensions and type are forced to the same values as the input.
    void setOutputColorImage( std::shared_ptr< iolink::ImageView > outputColorImage );

    // Method to launch the command.
    void execute();

};

/// Reduces color artifacts with a demosaicing algorithm.
/// @param inputColorImage The color input image.
/// @param kernelSize The size of the kernel (the side in pixels of the square window).
/// @param numberOfIterations The number of iterations of the demosaicing process (must be a positive integer).
/// @param outputColorImage The color output image. Its dimensions and type are forced to the same values as the input.
/// @return Returns the outputColorImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
colorAntialiasing2d( std::shared_ptr< iolink::ImageView > inputColorImage,
                     int32_t kernelSize,
                     int32_t numberOfIterations,
                     std::shared_ptr< iolink::ImageView > outputColorImage = nullptr );
} // namespace imagedev
