/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>
#include <ImageDev/Data/GlobalMeasurements/CompareMsr.h>

namespace imagedev
{
/// Performs a comparison test between an image and value and outputs the number of pixels that successfully passed the test.
class IMAGEDEV_CPP_API CompareValue final : public GenericAlgorithm
{
public:
    /// The comparison test to perform between images.
    enum ComparisonCriterion
    {
    /// The number of pixels of the image having an intensity strictly less than the constant value.
        LESS_THAN = 0,
    /// The number of pixels of the image having an intensity less than or equal to the constant value.
        LESS_OR_EQUAL,
    /// The number of pixels of the image having an intensity equal to the constant value.
        EQUAL_TO,
    /// The number of pixels of the image having an intensity greater than or equal to the constant value.
        GREATER_OR_EQUAL,
    /// The number of pixels of the image having an intensity strictly greater than the constant value.
        GREATER_THAN,
    /// The number of pixels of the image having an intensity different than the constant value.
        NOT_EQUAL_TO
    };

    // Command constructor.
    CompareValue();


    /// Gets the inputImage parameter.
    /// The input image.
    std::shared_ptr< iolink::ImageView > inputImage() const;
    /// Sets the inputImage parameter.
    /// The input image.
    void setInputImage( std::shared_ptr< iolink::ImageView > inputImage );

    /// Gets the value parameter.
    /// The floating value to compare.
    double value() const;
    /// Sets the value parameter.
    /// The floating value to compare.
    void setValue( const double& value );

    /// Gets the comparisonCriterion parameter.
    /// The comparison test to perform between images.
    CompareValue::ComparisonCriterion comparisonCriterion() const;
    /// Sets the comparisonCriterion parameter.
    /// The comparison test to perform between images.
    void setComparisonCriterion( const CompareValue::ComparisonCriterion& comparisonCriterion );

    /// Gets the outputMeasurement parameter.
    /// The output measurement result.
    CompareMsr::Ptr outputMeasurement() const;

    // Method to launch the command.
    void execute();

};

/// Performs a comparison test between an image and value and outputs the number of pixels that successfully passed the test.
/// @param inputImage The input image.
/// @param value The floating value to compare.
/// @param comparisonCriterion The comparison test to perform between images.
/// @param outputMeasurement The output measurement result.
/// @return Returns the outputMeasurement output parameter.
IMAGEDEV_CPP_API 
CompareMsr::Ptr
compareValue( std::shared_ptr< iolink::ImageView > inputImage,
              double value,
              CompareValue::ComparisonCriterion comparisonCriterion,
              CompareMsr::Ptr outputMeasurement = nullptr );
} // namespace imagedev
