/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>
#include <ImageDev/Data/GlobalMeasurements/CrossCorrelation2dMsr.h>

namespace imagedev
{
// Output structure of the crossCorrelation2d function.
struct CrossCorrelation2dOutput
{
    /// The output correlation image. Its dimensions are forced to the same values as the input. Its data type is forced to floating point.
    std::shared_ptr< iolink::ImageView > outputImage;
    /// The correlation matching results.
    CrossCorrelation2dMsr::Ptr outputMeasurement;
};

/// Performs a correlation by convolution between a two-dimensional grayscale image and a grayscale kernel.
class IMAGEDEV_CPP_API CrossCorrelation2d final : public GenericAlgorithm
{
public:
    /// The normalization mode for correlation.
    enum CorrelationMode
    {
    /// Direct correlation (no normalization).
        DIRECT = 0,
    /// Mean normalized correlation (luminosity).
        MEAN,
    /// Variance normalized correlation (contrast).
        VARIANCE,
    /// Mean and variance normalized correlation (luminosity and contrast).
        MEAN_VARIANCE
    };

    // Command constructor.
    CrossCorrelation2d();


    /// Gets the inputImage parameter.
    /// The input grayscale image.
    std::shared_ptr< iolink::ImageView > inputImage() const;
    /// Sets the inputImage parameter.
    /// The input grayscale image.
    void setInputImage( std::shared_ptr< iolink::ImageView > inputImage );

    /// Gets the inputKernelImage parameter.
    /// The correlation kernel.
    std::shared_ptr< iolink::ImageView > inputKernelImage() const;
    /// Sets the inputKernelImage parameter.
    /// The correlation kernel.
    void setInputKernelImage( std::shared_ptr< iolink::ImageView > inputKernelImage );

    /// Gets the correlationMode parameter.
    /// The normalization mode for correlation.
    CrossCorrelation2d::CorrelationMode correlationMode() const;
    /// Sets the correlationMode parameter.
    /// The normalization mode for correlation.
    void setCorrelationMode( const CrossCorrelation2d::CorrelationMode& correlationMode );

    /// Gets the outputImage parameter.
    /// The output correlation image. Its dimensions are forced to the same values as the input. Its data type is forced to floating point.
    std::shared_ptr< iolink::ImageView > outputImage() const;
    /// Sets the outputImage parameter.
    /// The output correlation image. Its dimensions are forced to the same values as the input. Its data type is forced to floating point.
    void setOutputImage( std::shared_ptr< iolink::ImageView > outputImage );

    /// Gets the outputMeasurement parameter.
    /// The correlation matching results.
    CrossCorrelation2dMsr::Ptr outputMeasurement() const;

    // Method to launch the command.
    void execute();

};

/// Performs a correlation by convolution between a two-dimensional grayscale image and a grayscale kernel.
/// @param inputImage The input grayscale image.
/// @param inputKernelImage The correlation kernel.
/// @param correlationMode The normalization mode for correlation.
/// @param outputImage The output correlation image. Its dimensions are forced to the same values as the input. Its data type is forced to floating point.
/// @param outputMeasurement The correlation matching results.
/// @return Returns a CrossCorrelation2dOutput structure containing the outputImage and outputMeasurement output parameters.
IMAGEDEV_CPP_API 
CrossCorrelation2dOutput
crossCorrelation2d( std::shared_ptr< iolink::ImageView > inputImage,
                    std::shared_ptr< iolink::ImageView > inputKernelImage,
                    CrossCorrelation2d::CorrelationMode correlationMode,
                    std::shared_ptr< iolink::ImageView > outputImage = nullptr,
                    CrossCorrelation2dMsr::Ptr outputMeasurement = nullptr );
} // namespace imagedev
