/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Smooths a two-dimensional image using an advanced local edge analysis technique.
class IMAGEDEV_CPP_API CurvatureDrivenDiffusion final : public GenericAlgorithm
{
public:

    // Command constructor.
    CurvatureDrivenDiffusion();


    /// Gets the inputImage parameter.
    /// The input image.
    std::shared_ptr< iolink::ImageView > inputImage() const;
    /// Sets the inputImage parameter.
    /// The input image.
    void setInputImage( std::shared_ptr< iolink::ImageView > inputImage );

    /// Gets the inputMaskImage parameter.
    /// The optional binary mask defining area to process into input image (null to process the whole image). It must have same dimensions as the input image and cannot be null.
    std::shared_ptr< iolink::ImageView > inputMaskImage() const;
    /// Sets the inputMaskImage parameter.
    /// The optional binary mask defining area to process into input image (null to process the whole image). It must have same dimensions as the input image and cannot be null.
    void setInputMaskImage( std::shared_ptr< iolink::ImageView > inputMaskImage );

    /// Gets the numberOfIterations parameter.
    /// The number of iterations of the curvature-driven diffusion process (must be a positive integer).
    int32_t numberOfIterations() const;
    /// Sets the numberOfIterations parameter.
    /// The number of iterations of the curvature-driven diffusion process (must be a positive integer).
    void setNumberOfIterations( const int32_t& numberOfIterations );

    /// Gets the sharpnessFactor parameter.
    /// The edge preserving factor.
    double sharpnessFactor() const;
    /// Sets the sharpnessFactor parameter.
    /// The edge preserving factor.
    void setSharpnessFactor( const double& sharpnessFactor );

    /// Gets the anisotropyFactor parameter.
    /// The curvature-driven factor (value within ]0, 1[).
    double anisotropyFactor() const;
    /// Sets the anisotropyFactor parameter.
    /// The curvature-driven factor (value within ]0, 1[).
    void setAnisotropyFactor( const double& anisotropyFactor );

    /// Gets the outputImage parameter.
    /// The output image. Its dimensions, type, and calibration are forced to the same values as the input.
    std::shared_ptr< iolink::ImageView > outputImage() const;
    /// Sets the outputImage parameter.
    /// The output image. Its dimensions, type, and calibration are forced to the same values as the input.
    void setOutputImage( std::shared_ptr< iolink::ImageView > outputImage );

    // Method to launch the command.
    void execute();

};

/// Smooths a two-dimensional image using an advanced local edge analysis technique.
/// @param inputImage The input image.
/// @param inputMaskImage The optional binary mask defining area to process into input image (null to process the whole image). It must have same dimensions as the input image and cannot be null.
/// @param numberOfIterations The number of iterations of the curvature-driven diffusion process (must be a positive integer).
/// @param sharpnessFactor The edge preserving factor.
/// @param anisotropyFactor The curvature-driven factor (value within ]0, 1[).
/// @param outputImage The output image. Its dimensions, type, and calibration are forced to the same values as the input.
/// @return Returns the outputImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
curvatureDrivenDiffusion( std::shared_ptr< iolink::ImageView > inputImage,
                          std::shared_ptr< iolink::ImageView > inputMaskImage,
                          int32_t numberOfIterations,
                          double sharpnessFactor,
                          double anisotropyFactor,
                          std::shared_ptr< iolink::ImageView > outputImage = nullptr );
} // namespace imagedev
