/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Enhances contrast and removes blur from a two-dimensional image.
class IMAGEDEV_CPP_API Deblurring2d final : public GenericAlgorithm
{
public:
    /// The output data type. It can either be the same as the input type, or forced to be float. In the case of floating input images, this parameter has no effect.
    enum OutputType
    {
    /// The output image has same type as the input image. In the case of integer images, this mode can lead to a loss of precision.
        SAME_AS_INPUT = 0,
    /// The output image type is forced to floating point.
        FLOAT_32_BIT
    };

    // Command constructor.
    Deblurring2d();


    /// Gets the inputImage parameter.
    /// The input image.
    std::shared_ptr< iolink::ImageView > inputImage() const;
    /// Sets the inputImage parameter.
    /// The input image.
    void setInputImage( std::shared_ptr< iolink::ImageView > inputImage );

    /// Gets the sharpeningFactor parameter.
    /// The sharpening factor.
    double sharpeningFactor() const;
    /// Sets the sharpeningFactor parameter.
    /// The sharpening factor.
    void setSharpeningFactor( const double& sharpeningFactor );

    /// Gets the outputType parameter.
    /// The output data type. It can either be the same as the input type, or forced to be float. In the case of floating input images, this parameter has no effect.
    Deblurring2d::OutputType outputType() const;
    /// Sets the outputType parameter.
    /// The output data type. It can either be the same as the input type, or forced to be float. In the case of floating input images, this parameter has no effect.
    void setOutputType( const Deblurring2d::OutputType& outputType );

    /// Gets the outputImage parameter.
    /// The output image. Its dimensions are forced to the same values as the input. Its data type is promoted.
    std::shared_ptr< iolink::ImageView > outputImage() const;
    /// Sets the outputImage parameter.
    /// The output image. Its dimensions are forced to the same values as the input. Its data type is promoted.
    void setOutputImage( std::shared_ptr< iolink::ImageView > outputImage );

    // Method to launch the command.
    void execute();

};

/// Enhances contrast and removes blur from a two-dimensional image.
/// @param inputImage The input image.
/// @param sharpeningFactor The sharpening factor.
/// @param outputType The output data type. It can either be the same as the input type, or forced to be float. In the case of floating input images, this parameter has no effect.
/// @param outputImage The output image. Its dimensions are forced to the same values as the input. Its data type is promoted.
/// @return Returns the outputImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
deblurring2d( std::shared_ptr< iolink::ImageView > inputImage,
              double sharpeningFactor,
              Deblurring2d::OutputType outputType,
              std::shared_ptr< iolink::ImageView > outputImage = nullptr );
} // namespace imagedev
