/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
// Output structure of the deinterlaceFrames2d function.
struct DeinterlaceFrames2dOutput
{
    /// The output even field image.
    std::shared_ptr< iolink::ImageView > outputEvenImage;
    /// The output odd field image.
    std::shared_ptr< iolink::ImageView > outputOddImage;
};

/// Separates even and odd frames from an interlaced image.
class IMAGEDEV_CPP_API DeinterlaceFrames2d final : public GenericAlgorithm
{
public:
    /// The split mode for generating the output images.
    enum SplitMode
    {
    /// This mode produces two images having half the Y size of the input image.
        HALF_IMAGE = 0,
    /// This mode produces two images having the same size as the input image by repeating every second horizontal line.
        FULL_IMAGE
    };

    // Command constructor.
    DeinterlaceFrames2d();


    /// Gets the inputImage parameter.
    /// The input image.
    std::shared_ptr< iolink::ImageView > inputImage() const;
    /// Sets the inputImage parameter.
    /// The input image.
    void setInputImage( std::shared_ptr< iolink::ImageView > inputImage );

    /// Gets the splitMode parameter.
    /// The split mode for generating the output images.
    DeinterlaceFrames2d::SplitMode splitMode() const;
    /// Sets the splitMode parameter.
    /// The split mode for generating the output images.
    void setSplitMode( const DeinterlaceFrames2d::SplitMode& splitMode );

    /// Gets the outputEvenImage parameter.
    /// The output even field image.
    std::shared_ptr< iolink::ImageView > outputEvenImage() const;
    /// Sets the outputEvenImage parameter.
    /// The output even field image.
    void setOutputEvenImage( std::shared_ptr< iolink::ImageView > outputEvenImage );

    /// Gets the outputOddImage parameter.
    /// The output odd field image.
    std::shared_ptr< iolink::ImageView > outputOddImage() const;
    /// Sets the outputOddImage parameter.
    /// The output odd field image.
    void setOutputOddImage( std::shared_ptr< iolink::ImageView > outputOddImage );

    // Method to launch the command.
    void execute();

};

/// Separates even and odd frames from an interlaced image.
/// @param inputImage The input image.
/// @param splitMode The split mode for generating the output images.
/// @param outputEvenImage The output even field image.
/// @param outputOddImage The output odd field image.
/// @return Returns a DeinterlaceFrames2dOutput structure containing the outputEvenImage and outputOddImage output parameters.
IMAGEDEV_CPP_API 
DeinterlaceFrames2dOutput
deinterlaceFrames2d( std::shared_ptr< iolink::ImageView > inputImage,
                     DeinterlaceFrames2d::SplitMode splitMode,
                     std::shared_ptr< iolink::ImageView > outputEvenImage = nullptr,
                     std::shared_ptr< iolink::ImageView > outputOddImage = nullptr );
} // namespace imagedev
