/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/Vector.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Smooths an image using a kernel based on an exponential distribution.
class IMAGEDEV_CPP_API ExponentialFilter2d final : public GenericAlgorithm
{
public:
    /// The automatic intensity scaling mode.
    enum AutoScale
    {
    /// The result is not normalized; it corresponds to the weighted sum of the window elements.
        NO = 0,
    /// The result is automatically normalized by the sum of the kernel weights.
        YES
    };

    // Command constructor.
    ExponentialFilter2d();


    /// Gets the inputImage parameter.
    /// The input image.
    std::shared_ptr< iolink::ImageView > inputImage() const;
    /// Sets the inputImage parameter.
    /// The input image.
    void setInputImage( std::shared_ptr< iolink::ImageView > inputImage );

    /// Gets the alphaFactor parameter.
    /// The alpha factor. The lower this value, the smoother the result. This value must be greater than 0. Practically, this filter response is a mostly visible in the [0.3, 5.3] range.
    double alphaFactor() const;
    /// Sets the alphaFactor parameter.
    /// The alpha factor. The lower this value, the smoother the result. This value must be greater than 0. Practically, this filter response is a mostly visible in the [0.3, 5.3] range.
    void setAlphaFactor( const double& alphaFactor );

    /// Gets the kernelSize parameter.
    /// The size of the kernel.
    iolink::Vector2i32 kernelSize() const;
    /// Sets the kernelSize parameter.
    /// The size of the kernel.
    void setKernelSize( const iolink::Vector2i32& kernelSize );

    /// Gets the autoScale parameter.
    /// The automatic intensity scaling mode.
    ExponentialFilter2d::AutoScale autoScale() const;
    /// Sets the autoScale parameter.
    /// The automatic intensity scaling mode.
    void setAutoScale( const ExponentialFilter2d::AutoScale& autoScale );

    /// Gets the outputImage parameter.
    /// The output image. Its dimensions are forced to the same values as the input. Its data type is promoted to avoid overflows in the non-normalized mode.
    std::shared_ptr< iolink::ImageView > outputImage() const;
    /// Sets the outputImage parameter.
    /// The output image. Its dimensions are forced to the same values as the input. Its data type is promoted to avoid overflows in the non-normalized mode.
    void setOutputImage( std::shared_ptr< iolink::ImageView > outputImage );

    // Method to launch the command.
    void execute();

};

/// Smooths an image using a kernel based on an exponential distribution.
/// @param inputImage The input image.
/// @param alphaFactor The alpha factor. The lower this value, the smoother the result. This value must be greater than 0. Practically, this filter response is a mostly visible in the [0.3, 5.3] range.
/// @param kernelSize The size of the kernel.
/// @param autoScale The automatic intensity scaling mode.
/// @param outputImage The output image. Its dimensions are forced to the same values as the input. Its data type is promoted to avoid overflows in the non-normalized mode.
/// @return Returns the outputImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
exponentialFilter2d( std::shared_ptr< iolink::ImageView > inputImage,
                     double alphaFactor,
                     const iolink::Vector2i32& kernelSize,
                     ExponentialFilter2d::AutoScale autoScale,
                     std::shared_ptr< iolink::ImageView > outputImage = nullptr );
} // namespace imagedev
