/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <ImageDev/Data/AnalysisMeasurements/AnalysisMsr.h>
#include <ImageDev/Data/AnalysisMeasurements/AnalysisMsr.h>

namespace imagedev
{
/// Filters objects from an analysis object.
class IMAGEDEV_CPP_API FilterAnalysis final : public GenericAlgorithm
{
public:

    // Command constructor.
    FilterAnalysis();


    /// Gets the inputAnalysis parameter.
    /// The input analysis.
    AnalysisMsr::Ptr inputAnalysis() const;
    /// Sets the inputAnalysis parameter.
    /// The input analysis.
    void setInputAnalysis( const AnalysisMsr::Ptr& inputAnalysis );

    /// Gets the inputFilter parameter.
    /// The input filter formula.
    std::string inputFilter() const;
    /// Sets the inputFilter parameter.
    /// The input filter formula.
    void setInputFilter( const std::string& inputFilter );

    /// Gets the outputAnalysis parameter.
    /// The output analysis.
    AnalysisMsr::Ptr outputAnalysis() const;

    // Method to launch the command.
    void execute();

};

/// Filters objects from an analysis object.
/// @param inputAnalysis The input analysis.
/// @param inputFilter The input filter formula.
/// @param outputAnalysis The output analysis.
/// @return Returns the outputAnalysis output parameter.
IMAGEDEV_CPP_API 
AnalysisMsr::Ptr
filterAnalysis( AnalysisMsr::Ptr inputAnalysis,
                const std::string& inputFilter,
                AnalysisMsr::Ptr outputAnalysis = nullptr );
} // namespace imagedev
