/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/Vector.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Approximates the convolution of a two-dimensional image with a Gaussian kernel or its derivative.
class IMAGEDEV_CPP_API GaussianDerivative2d final : public GenericAlgorithm
{
public:

    // Command constructor.
    GaussianDerivative2d();


    /// Gets the inputImage parameter.
    /// The input image.
    std::shared_ptr< iolink::ImageView > inputImage() const;
    /// Sets the inputImage parameter.
    /// The input image.
    void setInputImage( std::shared_ptr< iolink::ImageView > inputImage );

    /// Gets the orderDerivative parameter.
    /// The derivation order for each direction X and Y. Each value must be 0, 1 or 2.
    iolink::Vector2i32 orderDerivative() const;
    /// Sets the orderDerivative parameter.
    /// The derivation order for each direction X and Y. Each value must be 0, 1 or 2.
    void setOrderDerivative( const iolink::Vector2i32& orderDerivative );

    /// Gets the standardDeviation parameter.
    /// The sigma value of the Gaussian filter for each direction X and Y. Each value must be greater than or equal to 0.1.
    iolink::Vector2d standardDeviation() const;
    /// Sets the standardDeviation parameter.
    /// The sigma value of the Gaussian filter for each direction X and Y. Each value must be greater than or equal to 0.1.
    void setStandardDeviation( const iolink::Vector2d& standardDeviation );

    /// Gets the outputImage parameter.
    /// The output image. Its dimensions, calibration and interpretation are forced to the same values as the input image. Its type is forced to float.
    std::shared_ptr< iolink::ImageView > outputImage() const;
    /// Sets the outputImage parameter.
    /// The output image. Its dimensions, calibration and interpretation are forced to the same values as the input image. Its type is forced to float.
    void setOutputImage( std::shared_ptr< iolink::ImageView > outputImage );

    // Method to launch the command.
    void execute();

};

/// Approximates the convolution of a two-dimensional image with a Gaussian kernel or its derivative.
/// @param inputImage The input image.
/// @param orderDerivative The derivation order for each direction X and Y. Each value must be 0, 1 or 2.
/// @param standardDeviation The sigma value of the Gaussian filter for each direction X and Y. Each value must be greater than or equal to 0.1.
/// @param outputImage The output image. Its dimensions, calibration and interpretation are forced to the same values as the input image. Its type is forced to float.
/// @return Returns the outputImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
gaussianDerivative2d( std::shared_ptr< iolink::ImageView > inputImage,
                      const iolink::Vector2i32& orderDerivative,
                      const iolink::Vector2d& standardDeviation,
                      std::shared_ptr< iolink::ImageView > outputImage = nullptr );
} // namespace imagedev
