/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Extracts a given channel from a color image into a grayscale image.
class IMAGEDEV_CPP_API GetColorChannel final : public GenericAlgorithm
{
public:

    // Command constructor.
    GetColorChannel();


    /// Gets the inputColorImage parameter.
    /// The color or multi-channel input image.
    std::shared_ptr< iolink::ImageView > inputColorImage() const;
    /// Sets the inputColorImage parameter.
    /// The color or multi-channel input image.
    void setInputColorImage( std::shared_ptr< iolink::ImageView > inputColorImage );

    /// Gets the channel parameter.
    /// The index of the channel to extract. In the case of an RGB input: 0 for Red, 1 for Green, 2 for Blue.
    int32_t channel() const;
    /// Sets the channel parameter.
    /// The index of the channel to extract. In the case of an RGB input: 0 for Red, 1 for Green, 2 for Blue.
    void setChannel( const int32_t& channel );

    /// Gets the outputGrayImage parameter.
    /// The grayscale output image representing the extracted channel. Its spatial dimensions and type are forced to the same values as the input.
    std::shared_ptr< iolink::ImageView > outputGrayImage() const;
    /// Sets the outputGrayImage parameter.
    /// The grayscale output image representing the extracted channel. Its spatial dimensions and type are forced to the same values as the input.
    void setOutputGrayImage( std::shared_ptr< iolink::ImageView > outputGrayImage );

    // Method to launch the command.
    void execute();

};

/// Extracts a given channel from a color image into a grayscale image.
/// @param inputColorImage The color or multi-channel input image.
/// @param channel The index of the channel to extract. In the case of an RGB input: 0 for Red, 1 for Green, 2 for Blue.
/// @param outputGrayImage The grayscale output image representing the extracted channel. Its spatial dimensions and type are forced to the same values as the input.
/// @return Returns the outputGrayImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
getColorChannel( std::shared_ptr< iolink::ImageView > inputColorImage,
                 int32_t channel,
                 std::shared_ptr< iolink::ImageView > outputGrayImage = nullptr );
} // namespace imagedev
