/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Removes the non-local maxima from the gradient amplitude of a two-dimensional image.
class IMAGEDEV_CPP_API ImageLocalMaxima2d final : public GenericAlgorithm
{
public:

    // Command constructor.
    ImageLocalMaxima2d();


    /// Gets the inputImageX parameter.
    /// The X-gradient input image.
    std::shared_ptr< iolink::ImageView > inputImageX() const;
    /// Sets the inputImageX parameter.
    /// The X-gradient input image.
    void setInputImageX( std::shared_ptr< iolink::ImageView > inputImageX );

    /// Gets the inputImageY parameter.
    /// The Y-gradient input image.
    std::shared_ptr< iolink::ImageView > inputImageY() const;
    /// Sets the inputImageY parameter.
    /// The Y-gradient input image.
    void setInputImageY( std::shared_ptr< iolink::ImageView > inputImageY );

    /// Gets the inputAmplitudeImage parameter.
    /// The gradient amplitude input image.
    std::shared_ptr< iolink::ImageView > inputAmplitudeImage() const;
    /// Sets the inputAmplitudeImage parameter.
    /// The gradient amplitude input image.
    void setInputAmplitudeImage( std::shared_ptr< iolink::ImageView > inputAmplitudeImage );

    /// Gets the outputImage parameter.
    /// The output image.
    std::shared_ptr< iolink::ImageView > outputImage() const;
    /// Sets the outputImage parameter.
    /// The output image.
    void setOutputImage( std::shared_ptr< iolink::ImageView > outputImage );

    // Method to launch the command.
    void execute();

};

/// Removes the non-local maxima from the gradient amplitude of a two-dimensional image.
/// @param inputImageX The X-gradient input image.
/// @param inputImageY The Y-gradient input image.
/// @param inputAmplitudeImage The gradient amplitude input image.
/// @param outputImage The output image.
/// @return Returns the outputImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
imageLocalMaxima2d( std::shared_ptr< iolink::ImageView > inputImageX,
                    std::shared_ptr< iolink::ImageView > inputImageY,
                    std::shared_ptr< iolink::ImageView > inputAmplitudeImage,
                    std::shared_ptr< iolink::ImageView > outputImage = nullptr );
} // namespace imagedev
