/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Assigns the same label to each connected component pixel set of a two-dimensional binary or label image.
class IMAGEDEV_CPP_API Labeling2d final : public GenericAlgorithm
{
public:
    /// The minimum output data type. Automatically changed if not sufficient to encode all labels.
    enum LabelType
    {
    /// The minimum output data type is 8-bit per pixel.
        LABEL_8_BIT = 0,
    /// The minimum output data type is 16-bit per pixel.
        LABEL_16_BIT,
    /// The minimum output data type is 32-bit per pixel.
        LABEL_32_BIT
    };
    /// The 2D neighborhood configuration defining the connected components.
    enum Neighborhood
    {
    /// Connected components are defined by a 4-neighbor connectivity. The connectivity pattern is a cross.
        CONNECTIVITY_4 = 0,
    /// Connected components are defined by a 8-neighbor connectivity. The connectivity pattern is a square.
        CONNECTIVITY_8
    };

    // Command constructor.
    Labeling2d();


    /// Gets the inputObjectImage parameter.
    /// The input binary or label image.
    std::shared_ptr< iolink::ImageView > inputObjectImage() const;
    /// Sets the inputObjectImage parameter.
    /// The input binary or label image.
    void setInputObjectImage( std::shared_ptr< iolink::ImageView > inputObjectImage );

    /// Gets the labelType parameter.
    /// The minimum output data type. Automatically changed if not sufficient to encode all labels.
    Labeling2d::LabelType labelType() const;
    /// Sets the labelType parameter.
    /// The minimum output data type. Automatically changed if not sufficient to encode all labels.
    void setLabelType( const Labeling2d::LabelType& labelType );

    /// Gets the neighborhood parameter.
    /// The 2D neighborhood configuration defining the connected components.
    Labeling2d::Neighborhood neighborhood() const;
    /// Sets the neighborhood parameter.
    /// The 2D neighborhood configuration defining the connected components.
    void setNeighborhood( const Labeling2d::Neighborhood& neighborhood );

    /// Gets the outputLabelImage parameter.
    /// The output label image. Its dimensions are forced to the same values as the input image. Its type depends on the number of objects and the labelType parameter.
    std::shared_ptr< iolink::ImageView > outputLabelImage() const;
    /// Sets the outputLabelImage parameter.
    /// The output label image. Its dimensions are forced to the same values as the input image. Its type depends on the number of objects and the labelType parameter.
    void setOutputLabelImage( std::shared_ptr< iolink::ImageView > outputLabelImage );

    // Method to launch the command.
    void execute();

};

/// Assigns the same label to each connected component pixel set of a two-dimensional binary or label image.
/// @param inputObjectImage The input binary or label image.
/// @param labelType The minimum output data type. Automatically changed if not sufficient to encode all labels.
/// @param neighborhood The 2D neighborhood configuration defining the connected components.
/// @param outputLabelImage The output label image. Its dimensions are forced to the same values as the input image. Its type depends on the number of objects and the labelType parameter.
/// @return Returns the outputLabelImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
labeling2d( std::shared_ptr< iolink::ImageView > inputObjectImage,
            Labeling2d::LabelType labelType,
            Labeling2d::Neighborhood neighborhood,
            std::shared_ptr< iolink::ImageView > outputLabelImage = nullptr );
} // namespace imagedev
