/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Performs a pointwise logical operation between two images.
class IMAGEDEV_CPP_API LogicalOperationWithImage final : public GenericAlgorithm
{
public:
    /// The operator to apply.
    enum LogicalOperator
    {
    /// The logical AND operator performs a bitwise conjunction between two images.
        AND = 0,
    /// The logical OR operator performs a bitwise disjunction between two images.
        OR,
    /// The logical XOR operator performs a bitwise exclusive disjunction between two images.
        XOR,
    /// The logical NAND operator performs a bitwise alternative denial between two images.
        NAND,
    /// The logical NOR operator performs a bitwise joint denial between two images.
        NOR,
    /// The logical NXOR operator performs a bitwise equivalence (or logical biconditional) between two images.
        NXOR,
    /// The logical SUBTRACT operator performs a bitwise logical difference between two images.
        SUBTRACT
    };

    // Command constructor.
    LogicalOperationWithImage();


    /// Gets the inputImage1 parameter.
    /// The first input image, must be integer, including grayscale, binary, label, and color.
    std::shared_ptr< iolink::ImageView > inputImage1() const;
    /// Sets the inputImage1 parameter.
    /// The first input image, must be integer, including grayscale, binary, label, and color.
    void setInputImage1( std::shared_ptr< iolink::ImageView > inputImage1 );

    /// Gets the inputImage2 parameter.
    /// The second input image, must have same dimensions and type as the first input.
    std::shared_ptr< iolink::ImageView > inputImage2() const;
    /// Sets the inputImage2 parameter.
    /// The second input image, must have same dimensions and type as the first input.
    void setInputImage2( std::shared_ptr< iolink::ImageView > inputImage2 );

    /// Gets the logicalOperator parameter.
    /// The operator to apply.
    LogicalOperationWithImage::LogicalOperator logicalOperator() const;
    /// Sets the logicalOperator parameter.
    /// The operator to apply.
    void setLogicalOperator( const LogicalOperationWithImage::LogicalOperator& logicalOperator );

    /// Gets the outputImage parameter.
    /// The output image, size and type are forced to the same values as the inputs.
    std::shared_ptr< iolink::ImageView > outputImage() const;
    /// Sets the outputImage parameter.
    /// The output image, size and type are forced to the same values as the inputs.
    void setOutputImage( std::shared_ptr< iolink::ImageView > outputImage );

    // Method to launch the command.
    void execute();

};

/// Performs a pointwise logical operation between two images.
/// @param inputImage1 The first input image, must be integer, including grayscale, binary, label, and color.
/// @param inputImage2 The second input image, must have same dimensions and type as the first input.
/// @param logicalOperator The operator to apply.
/// @param outputImage The output image, size and type are forced to the same values as the inputs.
/// @return Returns the outputImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
logicalOperationWithImage( std::shared_ptr< iolink::ImageView > inputImage1,
                           std::shared_ptr< iolink::ImageView > inputImage2,
                           LogicalOperationWithImage::LogicalOperator logicalOperator,
                           std::shared_ptr< iolink::ImageView > outputImage = nullptr );
} // namespace imagedev
