/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Replaces all labels of the input image by the result of an individual measurement.
class IMAGEDEV_CPP_API MeasurementToImage final : public GenericAlgorithm
{
public:

    // Command constructor.
    MeasurementToImage();


    /// Gets the inputLabelImage parameter.
    /// The input label image.
    std::shared_ptr< iolink::ImageView > inputLabelImage() const;
    /// Sets the inputLabelImage parameter.
    /// The input label image.
    void setInputLabelImage( std::shared_ptr< iolink::ImageView > inputLabelImage );

    /// Gets the inputGrayImage parameter.
    /// The input grayscale image that contains the intensity information. It must have the same dimensions as the label input image. It is only used with measurements requiring an intensity image, and is ignored with other measurements. If it equals null, the label input image will be used as the intensity input image.
    std::shared_ptr< iolink::ImageView > inputGrayImage() const;
    /// Sets the inputGrayImage parameter.
    /// The input grayscale image that contains the intensity information. It must have the same dimensions as the label input image. It is only used with measurements requiring an intensity image, and is ignored with other measurements. If it equals null, the label input image will be used as the intensity input image.
    void setInputGrayImage( std::shared_ptr< iolink::ImageView > inputGrayImage );

    /// Gets the measurement parameter.
    /// The measurement defining the output values.
    std::string measurement() const;
    /// Sets the measurement parameter.
    /// The measurement defining the output values.
    void setMeasurement( const std::string& measurement );

    /// Gets the outputImage parameter.
    /// The output image. Its dimensions are forced to the same values as the input. Its data type is forced to 32-bit floating point or integer, depending on the selected measurement.
    std::shared_ptr< iolink::ImageView > outputImage() const;
    /// Sets the outputImage parameter.
    /// The output image. Its dimensions are forced to the same values as the input. Its data type is forced to 32-bit floating point or integer, depending on the selected measurement.
    void setOutputImage( std::shared_ptr< iolink::ImageView > outputImage );

    // Method to launch the command.
    void execute();

};

/// Replaces all labels of the input image by the result of an individual measurement.
/// @param inputLabelImage The input label image.
/// @param inputGrayImage The input grayscale image that contains the intensity information. It must have the same dimensions as the label input image. It is only used with measurements requiring an intensity image, and is ignored with other measurements. If it equals null, the label input image will be used as the intensity input image.
/// @param measurement The measurement defining the output values.
/// @param outputImage The output image. Its dimensions are forced to the same values as the input. Its data type is forced to 32-bit floating point or integer, depending on the selected measurement.
/// @return Returns the outputImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
measurementToImage( std::shared_ptr< iolink::ImageView > inputLabelImage,
                    std::shared_ptr< iolink::ImageView > inputGrayImage,
                    const std::string& measurement,
                    std::shared_ptr< iolink::ImageView > outputImage = nullptr );
} // namespace imagedev
