/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Creates a two-dimensional binary image containing a series of parallel oriented lines.
class IMAGEDEV_CPP_API OrientedLinesImage2d final : public GenericAlgorithm
{
public:

    // Command constructor.
    OrientedLinesImage2d();


    /// Gets the imageSizeX parameter.
    /// The X size in pixels of the output image.
    int32_t imageSizeX() const;
    /// Sets the imageSizeX parameter.
    /// The X size in pixels of the output image.
    void setImageSizeX( const int32_t& imageSizeX );

    /// Gets the imageSizeY parameter.
    /// The Y size in pixels of the output image.
    int32_t imageSizeY() const;
    /// Sets the imageSizeY parameter.
    /// The Y size in pixels of the output image.
    void setImageSizeY( const int32_t& imageSizeY );

    /// Gets the orientationAngle parameter.
    /// The lines orientation in degrees from the X axis.
    double orientationAngle() const;
    /// Sets the orientationAngle parameter.
    /// The lines orientation in degrees from the X axis.
    void setOrientationAngle( const double& orientationAngle );

    /// Gets the offset parameter.
    /// The distance in pixels between two lines.
    double offset() const;
    /// Sets the offset parameter.
    /// The distance in pixels between two lines.
    void setOffset( const double& offset );

    /// Gets the outputBinaryImage parameter.
    /// The output binary image.
    std::shared_ptr< iolink::ImageView > outputBinaryImage() const;
    /// Sets the outputBinaryImage parameter.
    /// The output binary image.
    void setOutputBinaryImage( std::shared_ptr< iolink::ImageView > outputBinaryImage );

    // Method to launch the command.
    void execute();

};

/// Creates a two-dimensional binary image containing a series of parallel oriented lines.
/// @param imageSizeX The X size in pixels of the output image.
/// @param imageSizeY The Y size in pixels of the output image.
/// @param orientationAngle The lines orientation in degrees from the X axis.
/// @param offset The distance in pixels between two lines.
/// @param outputBinaryImage The output binary image.
/// @return Returns the outputBinaryImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
orientedLinesImage2d( int32_t imageSizeX,
                      int32_t imageSizeY,
                      double orientationAngle,
                      double offset,
                      std::shared_ptr< iolink::ImageView > outputBinaryImage = nullptr );
} // namespace imagedev
