/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Creates a three-dimensional binary image containing a series of parallel oriented lines.
class IMAGEDEV_CPP_API OrientedLinesImage3d final : public GenericAlgorithm
{
public:

    // Command constructor.
    OrientedLinesImage3d();


    /// Gets the imageSizeX parameter.
    /// The X size in voxels of the output image.
    int32_t imageSizeX() const;
    /// Sets the imageSizeX parameter.
    /// The X size in voxels of the output image.
    void setImageSizeX( const int32_t& imageSizeX );

    /// Gets the imageSizeY parameter.
    /// The Y size in voxels of the output image.
    int32_t imageSizeY() const;
    /// Sets the imageSizeY parameter.
    /// The Y size in voxels of the output image.
    void setImageSizeY( const int32_t& imageSizeY );

    /// Gets the imageSizeZ parameter.
    /// The Z size in voxels of the output image.
    int32_t imageSizeZ() const;
    /// Sets the imageSizeZ parameter.
    /// The Z size in voxels of the output image.
    void setImageSizeZ( const int32_t& imageSizeZ );

    /// Gets the thetaAngle parameter.
    /// The polar angle in degrees of lines orientation.
    double thetaAngle() const;
    /// Sets the thetaAngle parameter.
    /// The polar angle in degrees of lines orientation.
    void setThetaAngle( const double& thetaAngle );

    /// Gets the phiAngle parameter.
    /// The azimuthal angle in degrees of lines orientation.
    double phiAngle() const;
    /// Sets the phiAngle parameter.
    /// The azimuthal angle in degrees of lines orientation.
    void setPhiAngle( const double& phiAngle );

    /// Gets the alphaAngle parameter.
    /// The alpha angle in degrees defining the grid orientation in a plane orthogonal to the lines direction.
    double alphaAngle() const;
    /// Sets the alphaAngle parameter.
    /// The alpha angle in degrees defining the grid orientation in a plane orthogonal to the lines direction.
    void setAlphaAngle( const double& alphaAngle );

    /// Gets the offset parameter.
    /// The distance in voxels between two lines.
    double offset() const;
    /// Sets the offset parameter.
    /// The distance in voxels between two lines.
    void setOffset( const double& offset );

    /// Gets the outputBinaryImage parameter.
    /// The output binary image.
    std::shared_ptr< iolink::ImageView > outputBinaryImage() const;
    /// Sets the outputBinaryImage parameter.
    /// The output binary image.
    void setOutputBinaryImage( std::shared_ptr< iolink::ImageView > outputBinaryImage );

    // Method to launch the command.
    void execute();

};

/// Creates a three-dimensional binary image containing a series of parallel oriented lines.
/// @param imageSizeX The X size in voxels of the output image.
/// @param imageSizeY The Y size in voxels of the output image.
/// @param imageSizeZ The Z size in voxels of the output image.
/// @param thetaAngle The polar angle in degrees of lines orientation.
/// @param phiAngle The azimuthal angle in degrees of lines orientation.
/// @param alphaAngle The alpha angle in degrees defining the grid orientation in a plane orthogonal to the lines direction.
/// @param offset The distance in voxels between two lines.
/// @param outputBinaryImage The output binary image.
/// @return Returns the outputBinaryImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
orientedLinesImage3d( int32_t imageSizeX,
                      int32_t imageSizeY,
                      int32_t imageSizeZ,
                      double thetaAngle,
                      double phiAngle,
                      double alphaAngle,
                      double offset,
                      std::shared_ptr< iolink::ImageView > outputBinaryImage = nullptr );
} // namespace imagedev
