/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
// Output structure of the polarToCartesian2d function.
struct PolarToCartesian2dOutput
{
    /// The output real part image. Its dimensions and type are forced to the same values as the input.
    std::shared_ptr< iolink::ImageView > outputRealImage;
    /// The output imaginary part image. Its dimensions and type are forced to the same values as the input.
    std::shared_ptr< iolink::ImageView > outputImaginaryImage;
};

/// Transforms a pair of module and phase two-dimensional images into a pair of real and imaginary part images.
class IMAGEDEV_CPP_API PolarToCartesian2d final : public GenericAlgorithm
{
public:

    // Command constructor.
    PolarToCartesian2d();


    /// Gets the inputModulusImage parameter.
    /// The modulus input image. It must be a floating point image.
    std::shared_ptr< iolink::ImageView > inputModulusImage() const;
    /// Sets the inputModulusImage parameter.
    /// The modulus input image. It must be a floating point image.
    void setInputModulusImage( std::shared_ptr< iolink::ImageView > inputModulusImage );

    /// Gets the inputPhaseImage parameter.
    /// The phase input image. This image must have same dimensions and data type as the modulus input image.
    std::shared_ptr< iolink::ImageView > inputPhaseImage() const;
    /// Sets the inputPhaseImage parameter.
    /// The phase input image. This image must have same dimensions and data type as the modulus input image.
    void setInputPhaseImage( std::shared_ptr< iolink::ImageView > inputPhaseImage );

    /// Gets the outputRealImage parameter.
    /// The output real part image. Its dimensions and type are forced to the same values as the input.
    std::shared_ptr< iolink::ImageView > outputRealImage() const;
    /// Sets the outputRealImage parameter.
    /// The output real part image. Its dimensions and type are forced to the same values as the input.
    void setOutputRealImage( std::shared_ptr< iolink::ImageView > outputRealImage );

    /// Gets the outputImaginaryImage parameter.
    /// The output imaginary part image. Its dimensions and type are forced to the same values as the input.
    std::shared_ptr< iolink::ImageView > outputImaginaryImage() const;
    /// Sets the outputImaginaryImage parameter.
    /// The output imaginary part image. Its dimensions and type are forced to the same values as the input.
    void setOutputImaginaryImage( std::shared_ptr< iolink::ImageView > outputImaginaryImage );

    // Method to launch the command.
    void execute();

};

/// Transforms a pair of module and phase two-dimensional images into a pair of real and imaginary part images.
/// @param inputModulusImage The modulus input image. It must be a floating point image.
/// @param inputPhaseImage The phase input image. This image must have same dimensions and data type as the modulus input image.
/// @param outputRealImage The output real part image. Its dimensions and type are forced to the same values as the input.
/// @param outputImaginaryImage The output imaginary part image. Its dimensions and type are forced to the same values as the input.
/// @return Returns a PolarToCartesian2dOutput structure containing the outputRealImage and outputImaginaryImage output parameters.
IMAGEDEV_CPP_API 
PolarToCartesian2dOutput
polarToCartesian2d( std::shared_ptr< iolink::ImageView > inputModulusImage,
                    std::shared_ptr< iolink::ImageView > inputPhaseImage,
                    std::shared_ptr< iolink::ImageView > outputRealImage = nullptr,
                    std::shared_ptr< iolink::ImageView > outputImaginaryImage = nullptr );
} // namespace imagedev
