/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Computes the regional maxima or minima of a two-dimensional grayscale image and marks them in a binary image.
class IMAGEDEV_CPP_API RegionalExtrema2d final : public GenericAlgorithm
{
public:
    /// The type of extrema to detect.
    enum ExtremaType
    {
    /// The regional minima are extracted from the input image.
        MINIMA = 0,
    /// The regional maxima are extracted from the input image.
        MAXIMA
    };
    /// The 2D neighborhood configuration used for geodesic propagation.
    enum Neighborhood
    {
    /// The neighborhood configuration is a cross.
        CONNECTIVITY_4 = 0,
    /// The neighborhood configuration is a square.
        CONNECTIVITY_8
    };

    // Command constructor.
    RegionalExtrema2d();


    /// Gets the inputImage parameter.
    /// The input grayscale image.
    std::shared_ptr< iolink::ImageView > inputImage() const;
    /// Sets the inputImage parameter.
    /// The input grayscale image.
    void setInputImage( std::shared_ptr< iolink::ImageView > inputImage );

    /// Gets the extremaType parameter.
    /// The type of extrema to detect.
    RegionalExtrema2d::ExtremaType extremaType() const;
    /// Sets the extremaType parameter.
    /// The type of extrema to detect.
    void setExtremaType( const RegionalExtrema2d::ExtremaType& extremaType );

    /// Gets the neighborhood parameter.
    /// The 2D neighborhood configuration used for geodesic propagation.
    RegionalExtrema2d::Neighborhood neighborhood() const;
    /// Sets the neighborhood parameter.
    /// The 2D neighborhood configuration used for geodesic propagation.
    void setNeighborhood( const RegionalExtrema2d::Neighborhood& neighborhood );

    /// Gets the outputBinaryImage parameter.
    /// The output binary image. Its dimensions are forced to the same values as the input.
    std::shared_ptr< iolink::ImageView > outputBinaryImage() const;
    /// Sets the outputBinaryImage parameter.
    /// The output binary image. Its dimensions are forced to the same values as the input.
    void setOutputBinaryImage( std::shared_ptr< iolink::ImageView > outputBinaryImage );

    // Method to launch the command.
    void execute();

};

/// Computes the regional maxima or minima of a two-dimensional grayscale image and marks them in a binary image.
/// @param inputImage The input grayscale image.
/// @param extremaType The type of extrema to detect.
/// @param neighborhood The 2D neighborhood configuration used for geodesic propagation.
/// @param outputBinaryImage The output binary image. Its dimensions are forced to the same values as the input.
/// @return Returns the outputBinaryImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
regionalExtrema2d( std::shared_ptr< iolink::ImageView > inputImage,
                   RegionalExtrema2d::ExtremaType extremaType,
                   RegionalExtrema2d::Neighborhood neighborhood,
                   std::shared_ptr< iolink::ImageView > outputBinaryImage = nullptr );
} // namespace imagedev
