/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/DataFrameView.h>

namespace imagedev
{
/// Computes a list of uniformly distributed three-dimensional rotations on the unit sphere.
class IMAGEDEV_CPP_API RotationGenerator3d final : public GenericAlgorithm
{
public:
    /// The way to define the distribution of rotations to generate.
    enum SamplingMode
    {
    /// The distribution is defined by a number of rotations.
        NUMBER_OF_ROTATIONS = 0,
    /// The distribution is defined by a pitch angle, in degree, between two neighbor orientations.
        ANGULAR_SAMPLING
    };

    // Command constructor.
    RotationGenerator3d();


    /// Gets the samplingMode parameter.
    /// The way to define the distribution of rotations to generate.
    RotationGenerator3d::SamplingMode samplingMode() const;
    /// Sets the samplingMode parameter.
    /// The way to define the distribution of rotations to generate.
    void setSamplingMode( const RotationGenerator3d::SamplingMode& samplingMode );

    /// Gets the numberOfRotations parameter.
    /// The number of desired rotations
    uint32_t numberOfRotations() const;
    /// Sets the numberOfRotations parameter.
    /// The number of desired rotations
    void setNumberOfRotations( const uint32_t& numberOfRotations );

    /// Gets the angularSampling parameter.
    /// The pitch angle, in degree, between two neighbor orientations.
    double angularSampling() const;
    /// Sets the angularSampling parameter.
    /// The pitch angle, in degree, between two neighbor orientations.
    void setAngularSampling( const double& angularSampling );

    /// Gets the orientationOnly parameter.
    /// The type of rotations to generate. If equal to true, the output rotations gives a uniform distribution of orientations. Else a uniform distribution of orientations is generated.
    bool orientationOnly() const;
    /// Sets the orientationOnly parameter.
    /// The type of rotations to generate. If equal to true, the output rotations gives a uniform distribution of orientations. Else a uniform distribution of orientations is generated.
    void setOrientationOnly( const bool& orientationOnly );

    /// Gets the rotationTable parameter.
    /// The output DataFrameView containing the rotations
    std::shared_ptr< iolink::DataFrameView > rotationTable() const;
    /// Sets the rotationTable parameter.
    /// The output DataFrameView containing the rotations
    void setRotationTable( const std::shared_ptr< iolink::DataFrameView >& rotationTable );

    // Method to launch the command.
    void execute();

};

/// Computes a list of uniformly distributed three-dimensional rotations on the unit sphere.
/// @param samplingMode The way to define the distribution of rotations to generate.
/// @param numberOfRotations The number of desired rotations
/// @param angularSampling The pitch angle, in degree, between two neighbor orientations.
/// @param orientationOnly The type of rotations to generate. If equal to true, the output rotations gives a uniform distribution of orientations. Else a uniform distribution of orientations is generated.
/// @param rotationTable The output DataFrameView containing the rotations
/// @return Returns the rotationTable output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::DataFrameView >
rotationGenerator3d( RotationGenerator3d::SamplingMode samplingMode,
                     uint32_t numberOfRotations,
                     double angularSampling,
                     bool orientationOnly,
                     std::shared_ptr< iolink::DataFrameView > rotationTable = nullptr );
} // namespace imagedev
