/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>
#include <ImageDev/Data/GlobalMeasurements/SegmentationMetricsObjectMsr.h>
#include <ImageDev/Data/GlobalMeasurements/SegmentationMetricsImageMsr.h>

namespace imagedev
{
// Output structure of the segmentationMetrics function.
struct SegmentationMetricsOutput
{
    /// The similarity results. The metrics are given for each label of the input image.
    SegmentationMetricsObjectMsr::Ptr outputClassMeasurement;
    /// The similarity results. The metrics are given globally for the input image.
    SegmentationMetricsImageMsr::Ptr outputImageMeasurement;
};

/// Computes classical quality metrics for assessing the quality of a segmentation relatively to a ground truth.
class IMAGEDEV_CPP_API SegmentationMetrics final : public GenericAlgorithm
{
public:
    /// The type of output measurement to compute.
    enum MetricScope
    {
    /// The segmentation metrics are only computed for each label of the input images. Only the object measurement output is filled.
        PER_CLASS = 0,
    /// The segmentation metrics are computed globally on the input images. Only the image measurement output is filled.
        PER_IMAGE,
    /// The segmentation metrics are computed globally and for each label of the input images. Both output measurement types are filled.
        BOTH
    };

    // Command constructor.
    SegmentationMetrics();


    /// Gets the inputObjectImage parameter.
    /// The input image. It can be a binary or a label image.
    std::shared_ptr< iolink::ImageView > inputObjectImage() const;
    /// Sets the inputObjectImage parameter.
    /// The input image. It can be a binary or a label image.
    void setInputObjectImage( std::shared_ptr< iolink::ImageView > inputObjectImage );

    /// Gets the inputReferenceImage parameter.
    /// The ground truth image. It can be a binary or a label image. It must have same shape and interpretation as the first input image.
    std::shared_ptr< iolink::ImageView > inputReferenceImage() const;
    /// Sets the inputReferenceImage parameter.
    /// The ground truth image. It can be a binary or a label image. It must have same shape and interpretation as the first input image.
    void setInputReferenceImage( std::shared_ptr< iolink::ImageView > inputReferenceImage );

    /// Gets the metricScope parameter.
    /// The type of output measurement to compute.
    SegmentationMetrics::MetricScope metricScope() const;
    /// Sets the metricScope parameter.
    /// The type of output measurement to compute.
    void setMetricScope( const SegmentationMetrics::MetricScope& metricScope );

    /// Gets the outputClassMeasurement parameter.
    /// The similarity results. The metrics are given for each label of the input image.
    SegmentationMetricsObjectMsr::Ptr outputClassMeasurement() const;

    /// Gets the outputImageMeasurement parameter.
    /// The similarity results. The metrics are given globally for the input image.
    SegmentationMetricsImageMsr::Ptr outputImageMeasurement() const;

    // Method to launch the command.
    void execute();

};

/// Computes classical quality metrics for assessing the quality of a segmentation relatively to a ground truth.
/// @param inputObjectImage The input image. It can be a binary or a label image.
/// @param inputReferenceImage The ground truth image. It can be a binary or a label image. It must have same shape and interpretation as the first input image.
/// @param metricScope The type of output measurement to compute.
/// @param outputClassMeasurement The similarity results. The metrics are given for each label of the input image.
/// @param outputImageMeasurement The similarity results. The metrics are given globally for the input image.
/// @return Returns a SegmentationMetricsOutput structure containing the outputClassMeasurement and outputImageMeasurement output parameters.
IMAGEDEV_CPP_API 
SegmentationMetricsOutput
segmentationMetrics( std::shared_ptr< iolink::ImageView > inputObjectImage,
                     std::shared_ptr< iolink::ImageView > inputReferenceImage,
                     SegmentationMetrics::MetricScope metricScope,
                     SegmentationMetricsObjectMsr::Ptr outputClassMeasurement = nullptr,
                     SegmentationMetricsImageMsr::Ptr outputImageMeasurement = nullptr );
} // namespace imagedev
