/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Concatenates two image sequences into a single one.
class IMAGEDEV_CPP_API SequenceConcatenation final : public GenericAlgorithm
{
public:

    // Command constructor.
    SequenceConcatenation();


    /// Gets the inputSequence1 parameter.
    /// The first sequence to concatenate. The ImageType must be IMAGE_SEQUENCE or VOLUME_SEQUENCE.
    std::shared_ptr< iolink::ImageView > inputSequence1() const;
    /// Sets the inputSequence1 parameter.
    /// The first sequence to concatenate. The ImageType must be IMAGE_SEQUENCE or VOLUME_SEQUENCE.
    void setInputSequence1( std::shared_ptr< iolink::ImageView > inputSequence1 );

    /// Gets the inputSequence2 parameter.
    /// The second sequence to concatenate. The ImageType must be IMAGE_SEQUENCE or VOLUME_SEQUENCE. Its data type and spatial dimensions must be the same as the first input sequence. Its number of frames  (sequence dimension) can be different.
    std::shared_ptr< iolink::ImageView > inputSequence2() const;
    /// Sets the inputSequence2 parameter.
    /// The second sequence to concatenate. The ImageType must be IMAGE_SEQUENCE or VOLUME_SEQUENCE. Its data type and spatial dimensions must be the same as the first input sequence. Its number of frames  (sequence dimension) can be different.
    void setInputSequence2( std::shared_ptr< iolink::ImageView > inputSequence2 );

    /// Gets the outputSequence parameter.
    /// The output sequence. Its spatial dimensions and type are forced to the same values as the inputs. Its sequence dimension is the sum of both inputs.
    std::shared_ptr< iolink::ImageView > outputSequence() const;
    /// Sets the outputSequence parameter.
    /// The output sequence. Its spatial dimensions and type are forced to the same values as the inputs. Its sequence dimension is the sum of both inputs.
    void setOutputSequence( std::shared_ptr< iolink::ImageView > outputSequence );

    // Method to launch the command.
    void execute();

};

/// Concatenates two image sequences into a single one.
/// @param inputSequence1 The first sequence to concatenate. The ImageType must be IMAGE_SEQUENCE or VOLUME_SEQUENCE.
/// @param inputSequence2 The second sequence to concatenate. The ImageType must be IMAGE_SEQUENCE or VOLUME_SEQUENCE. Its data type and spatial dimensions must be the same as the first input sequence. Its number of frames  (sequence dimension) can be different.
/// @param outputSequence The output sequence. Its spatial dimensions and type are forced to the same values as the inputs. Its sequence dimension is the sum of both inputs.
/// @return Returns the outputSequence output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
sequenceConcatenation( std::shared_ptr< iolink::ImageView > inputSequence1,
                       std::shared_ptr< iolink::ImageView > inputSequence2,
                       std::shared_ptr< iolink::ImageView > outputSequence = nullptr );
} // namespace imagedev
