/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Pastes a 2D image into a plane orthogonal to an axis of a 3D volume.
class IMAGEDEV_CPP_API SetSliceToVolume3d final : public GenericAlgorithm
{
public:
    /// The axis orthogonal to the plane to set.
    enum Axis
    {
    /// This mode sets the input plane orthogonal to X axis.
        X_AXIS = 0,
    /// This mode sets the input plane orthogonal to Y axis.
        Y_AXIS,
    /// This mode sets the input plane orthogonal to Z axis.
        Z_AXIS
    };

    // Command constructor.
    SetSliceToVolume3d();


    /// Gets the inputDestinationImage parameter.
    /// The input 3D image (the volume where the slice is inserted).
    std::shared_ptr< iolink::ImageView > inputDestinationImage() const;
    /// Sets the inputDestinationImage parameter.
    /// The input 3D image (the volume where the slice is inserted).
    void setInputDestinationImage( std::shared_ptr< iolink::ImageView > inputDestinationImage );

    /// Gets the inputSourceImage parameter.
    /// The input 2D image (the slice to insert).
    std::shared_ptr< iolink::ImageView > inputSourceImage() const;
    /// Sets the inputSourceImage parameter.
    /// The input 2D image (the slice to insert).
    void setInputSourceImage( std::shared_ptr< iolink::ImageView > inputSourceImage );

    /// Gets the axis parameter.
    /// The axis orthogonal to the plane to set.
    SetSliceToVolume3d::Axis axis() const;
    /// Sets the axis parameter.
    /// The axis orthogonal to the plane to set.
    void setAxis( const SetSliceToVolume3d::Axis& axis );

    /// Gets the sliceIndex parameter.
    /// The axis index where to insert the slice.
    int32_t sliceIndex() const;
    /// Sets the sliceIndex parameter.
    /// The axis index where to insert the slice.
    void setSliceIndex( const int32_t& sliceIndex );

    /// Gets the outputImage parameter.
    /// The output image.
    std::shared_ptr< iolink::ImageView > outputImage() const;
    /// Sets the outputImage parameter.
    /// The output image.
    void setOutputImage( std::shared_ptr< iolink::ImageView > outputImage );

    // Method to launch the command.
    void execute();

};

/// Pastes a 2D image into a plane orthogonal to an axis of a 3D volume.
/// @param inputDestinationImage The input 3D image (the volume where the slice is inserted).
/// @param inputSourceImage The input 2D image (the slice to insert).
/// @param axis The axis orthogonal to the plane to set.
/// @param sliceIndex The axis index where to insert the slice.
/// @param outputImage The output image.
/// @return Returns the outputImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
setSliceToVolume3d( std::shared_ptr< iolink::ImageView > inputDestinationImage,
                    std::shared_ptr< iolink::ImageView > inputSourceImage,
                    SetSliceToVolume3d::Axis axis,
                    int32_t sliceIndex,
                    std::shared_ptr< iolink::ImageView > outputImage = nullptr );
} // namespace imagedev
