/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Corrects the lighting conditions of an image according to a black and a white reference.
class IMAGEDEV_CPP_API ShadingCorrection final : public GenericAlgorithm
{
public:

    // Command constructor.
    ShadingCorrection();


    /// Gets the inputImage parameter.
    /// The input image to correct.
    std::shared_ptr< iolink::ImageView > inputImage() const;
    /// Sets the inputImage parameter.
    /// The input image to correct.
    void setInputImage( std::shared_ptr< iolink::ImageView > inputImage );

    /// Gets the inputBlackReferenceImage parameter.
    /// The input black reference image. If it equals null, the input image minimum is used as a constant value. This image must have same dimensions and type as the input image.
    std::shared_ptr< iolink::ImageView > inputBlackReferenceImage() const;
    /// Sets the inputBlackReferenceImage parameter.
    /// The input black reference image. If it equals null, the input image minimum is used as a constant value. This image must have same dimensions and type as the input image.
    void setInputBlackReferenceImage( std::shared_ptr< iolink::ImageView > inputBlackReferenceImage );

    /// Gets the inputWhiteReferenceImage parameter.
    /// The input white reference image. If it equals null, the input image maximum is used as a constant value. This image must have same dimensions and type as the input image.
    std::shared_ptr< iolink::ImageView > inputWhiteReferenceImage() const;
    /// Sets the inputWhiteReferenceImage parameter.
    /// The input white reference image. If it equals null, the input image maximum is used as a constant value. This image must have same dimensions and type as the input image.
    void setInputWhiteReferenceImage( std::shared_ptr< iolink::ImageView > inputWhiteReferenceImage );

    /// Gets the normalizationFactor parameter.
    /// The normalization factor.
    double normalizationFactor() const;
    /// Sets the normalizationFactor parameter.
    /// The normalization factor.
    void setNormalizationFactor( const double& normalizationFactor );

    /// Gets the outputImage parameter.
    /// The output image. Its dimensions and type are forced to the same values as the input.
    std::shared_ptr< iolink::ImageView > outputImage() const;
    /// Sets the outputImage parameter.
    /// The output image. Its dimensions and type are forced to the same values as the input.
    void setOutputImage( std::shared_ptr< iolink::ImageView > outputImage );

    // Method to launch the command.
    void execute();

};

/// Corrects the lighting conditions of an image according to a black and a white reference.
/// @param inputImage The input image to correct.
/// @param inputBlackReferenceImage The input black reference image. If it equals null, the input image minimum is used as a constant value. This image must have same dimensions and type as the input image.
/// @param inputWhiteReferenceImage The input white reference image. If it equals null, the input image maximum is used as a constant value. This image must have same dimensions and type as the input image.
/// @param normalizationFactor The normalization factor.
/// @param outputImage The output image. Its dimensions and type are forced to the same values as the input.
/// @return Returns the outputImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
shadingCorrection( std::shared_ptr< iolink::ImageView > inputImage,
                   std::shared_ptr< iolink::ImageView > inputBlackReferenceImage,
                   std::shared_ptr< iolink::ImageView > inputWhiteReferenceImage,
                   double normalizationFactor,
                   std::shared_ptr< iolink::ImageView > outputImage = nullptr );
} // namespace imagedev
