/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <vector>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Produces a new label image by assigning a same label to objects belonging to a same class of a user-defined measurement.
class IMAGEDEV_CPP_API SieveLabeling final : public GenericAlgorithm
{
public:

    // Command constructor.
    SieveLabeling();


    /// Gets the inputObjectImage parameter.
    /// The input binary or label image.
    std::shared_ptr< iolink::ImageView > inputObjectImage() const;
    /// Sets the inputObjectImage parameter.
    /// The input binary or label image.
    void setInputObjectImage( std::shared_ptr< iolink::ImageView > inputObjectImage );

    /// Gets the inputIntensityImage parameter.
    /// The input grayscale image that contains the intensity information. It must have the same dimensions as the label input image. It is only used with measurements requiring an intensity image, and is ignored with other measurements. If it equals null, the label input image will be used as the intensity input image.
    std::shared_ptr< iolink::ImageView > inputIntensityImage() const;
    /// Sets the inputIntensityImage parameter.
    /// The input grayscale image that contains the intensity information. It must have the same dimensions as the label input image. It is only used with measurements requiring an intensity image, and is ignored with other measurements. If it equals null, the label input image will be used as the intensity input image.
    void setInputIntensityImage( std::shared_ptr< iolink::ImageView > inputIntensityImage );

    /// Gets the sieveArray parameter.
    /// The array defining the bounds values of the sieve to apply.
    std::vector<double> sieveArray() const;
    /// Sets the sieveArray parameter.
    /// The array defining the bounds values of the sieve to apply.
    void setSieveArray( const std::vector<double>& sieveArray );

    /// Gets the measurement parameter.
    /// The native measurement on which the sieve is applied.
    std::string measurement() const;
    /// Sets the measurement parameter.
    /// The native measurement on which the sieve is applied.
    void setMeasurement( const std::string& measurement );

    /// Gets the outputLabelImage parameter.
    /// The output label image. Its dimensions are forced to the same values as the input.
    std::shared_ptr< iolink::ImageView > outputLabelImage() const;
    /// Sets the outputLabelImage parameter.
    /// The output label image. Its dimensions are forced to the same values as the input.
    void setOutputLabelImage( std::shared_ptr< iolink::ImageView > outputLabelImage );

    // Method to launch the command.
    void execute();

};

/// Produces a new label image by assigning a same label to objects belonging to a same class of a user-defined measurement.
/// @param inputObjectImage The input binary or label image.
/// @param inputIntensityImage The input grayscale image that contains the intensity information. It must have the same dimensions as the label input image. It is only used with measurements requiring an intensity image, and is ignored with other measurements. If it equals null, the label input image will be used as the intensity input image.
/// @param sieveArray The array defining the bounds values of the sieve to apply.
/// @param measurement The native measurement on which the sieve is applied.
/// @param outputLabelImage The output label image. Its dimensions are forced to the same values as the input.
/// @return Returns the outputLabelImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
sieveLabeling( std::shared_ptr< iolink::ImageView > inputObjectImage,
               std::shared_ptr< iolink::ImageView > inputIntensityImage,
               const std::vector<double>& sieveArray,
               const std::string& measurement,
               std::shared_ptr< iolink::ImageView > outputLabelImage = nullptr );
} // namespace imagedev
