/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Computes the shortest travel time in the objects of a binary image considering the weights given by an intensity image.
class IMAGEDEV_CPP_API TimeMap final : public GenericAlgorithm
{
public:

    // Command constructor.
    TimeMap();


    /// Gets the inputBinaryImage parameter.
    /// The binary input image.
    std::shared_ptr< iolink::ImageView > inputBinaryImage() const;
    /// Sets the inputBinaryImage parameter.
    /// The binary input image.
    void setInputBinaryImage( std::shared_ptr< iolink::ImageView > inputBinaryImage );

    /// Gets the inputIntensityImage parameter.
    /// The weight input image. It must have same dimensions as the input image.
    std::shared_ptr< iolink::ImageView > inputIntensityImage() const;
    /// Sets the inputIntensityImage parameter.
    /// The weight input image. It must have same dimensions as the input image.
    void setInputIntensityImage( std::shared_ptr< iolink::ImageView > inputIntensityImage );

    /// Gets the outputIntensityImage parameter.
    /// The output image. Its dimensions are forced to the same values as the input. Its data type is 32-bit floating point.
    std::shared_ptr< iolink::ImageView > outputIntensityImage() const;
    /// Sets the outputIntensityImage parameter.
    /// The output image. Its dimensions are forced to the same values as the input. Its data type is 32-bit floating point.
    void setOutputIntensityImage( std::shared_ptr< iolink::ImageView > outputIntensityImage );

    // Method to launch the command.
    void execute();

};

/// Computes the shortest travel time in the objects of a binary image considering the weights given by an intensity image.
/// @param inputBinaryImage The binary input image.
/// @param inputIntensityImage The weight input image. It must have same dimensions as the input image.
/// @param outputIntensityImage The output image. Its dimensions are forced to the same values as the input. Its data type is 32-bit floating point.
/// @return Returns the outputIntensityImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
timeMap( std::shared_ptr< iolink::ImageView > inputBinaryImage,
         std::shared_ptr< iolink::ImageView > inputIntensityImage,
         std::shared_ptr< iolink::ImageView > outputIntensityImage = nullptr );
} // namespace imagedev
