/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/Vector.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Detects the compact dark or bright areas of a grayscale image.
class IMAGEDEV_CPP_API TopHat final : public GenericAlgorithm
{
public:
    /// The lightness of objects to detect.
    enum ObjectLightness
    {
    /// A white Top-Hat is applied to detect small bright areas.
        BRIGHT_OBJECTS = 0,
    /// A black Top-Hat is applied to detect small dark areas.
        DARK_OBJECTS
    };

    // Command constructor.
    TopHat();


    /// Gets the inputGrayImage parameter.
    /// The input gray level image.
    std::shared_ptr< iolink::ImageView > inputGrayImage() const;
    /// Sets the inputGrayImage parameter.
    /// The input gray level image.
    void setInputGrayImage( std::shared_ptr< iolink::ImageView > inputGrayImage );

    /// Gets the kernelRadius parameter.
    /// The half size of the structuring element in pixels. A square structuring element always has an odd side length (3x3, 5x5, etc.) which is defined by twice the kernel radius + 1.
    int32_t kernelRadius() const;
    /// Sets the kernelRadius parameter.
    /// The half size of the structuring element in pixels. A square structuring element always has an odd side length (3x3, 5x5, etc.) which is defined by twice the kernel radius + 1.
    void setKernelRadius( const int32_t& kernelRadius );

    /// Gets the objectLightness parameter.
    /// The lightness of objects to detect.
    TopHat::ObjectLightness objectLightness() const;
    /// Sets the objectLightness parameter.
    /// The lightness of objects to detect.
    void setObjectLightness( const TopHat::ObjectLightness& objectLightness );

    /// Gets the thresholdRange parameter.
    /// The low and high threshold levels.
    iolink::Vector2d thresholdRange() const;
    /// Sets the thresholdRange parameter.
    /// The low and high threshold levels.
    void setThresholdRange( const iolink::Vector2d& thresholdRange );

    /// Gets the outputBinaryImage parameter.
    /// The output binary image. Its dimensions are forced to the same values as the input.
    std::shared_ptr< iolink::ImageView > outputBinaryImage() const;
    /// Sets the outputBinaryImage parameter.
    /// The output binary image. Its dimensions are forced to the same values as the input.
    void setOutputBinaryImage( std::shared_ptr< iolink::ImageView > outputBinaryImage );

    // Method to launch the command.
    void execute();

};

/// Detects the compact dark or bright areas of a grayscale image.
/// @param inputGrayImage The input gray level image.
/// @param kernelRadius The half size of the structuring element in pixels. A square structuring element always has an odd side length (3x3, 5x5, etc.) which is defined by twice the kernel radius + 1.
/// @param objectLightness The lightness of objects to detect.
/// @param thresholdRange The low and high threshold levels.
/// @param outputBinaryImage The output binary image. Its dimensions are forced to the same values as the input.
/// @return Returns the outputBinaryImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
topHat( std::shared_ptr< iolink::ImageView > inputGrayImage,
        int32_t kernelRadius,
        TopHat::ObjectLightness objectLightness,
        const iolink::Vector2d& thresholdRange,
        std::shared_ptr< iolink::ImageView > outputBinaryImage = nullptr );
} // namespace imagedev
