/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/ArrayX.h>
#include <memory>

namespace imagedev
{
/// Writes an ArrayXi64 object in a binary or text file.
class IMAGEDEV_CPP_API WriteArrayXi64 final : public GenericAlgorithm
{
public:
    /// The type of writting.
    enum WriteType
    {
    /// Writes as text.
        TEXT = 0,
    /// Writes as binary.
        BINARY
    };

    // Command constructor.
    WriteArrayXi64();


    /// Gets the inputArrayXi64 parameter.
    /// The input ArrayXi64 object to write.
    std::shared_ptr<iolink::ArrayXi64> inputArrayXi64() const;
    /// Sets the inputArrayXi64 parameter.
    /// The input ArrayXi64 object to write.
    void setInputArrayXi64( std::shared_ptr<iolink::ArrayXi64> inputArrayXi64 );

    /// Gets the filePath parameter.
    /// The file path where the ArrayXd is written.
    std::string filePath() const;
    /// Sets the filePath parameter.
    /// The file path where the ArrayXd is written.
    void setFilePath( const std::string& filePath );

    /// Gets the writeType parameter.
    /// The type of writting.
    WriteArrayXi64::WriteType writeType() const;
    /// Sets the writeType parameter.
    /// The type of writting.
    void setWriteType( const WriteArrayXi64::WriteType& writeType );

    /// Gets the overwrite parameter.
    /// Allows the overwriting of an existing file.
    bool overwrite() const;
    /// Sets the overwrite parameter.
    /// Allows the overwriting of an existing file.
    void setOverwrite( const bool& overwrite );

    // Method to launch the command.
    void execute();

};

/// Writes an ArrayXi64 object in a binary or text file.
/// @param inputArrayXi64 The input ArrayXi64 object to write.
/// @param filePath The file path where the ArrayXd is written.
/// @param writeType The type of writting.
/// @param overwrite Allows the overwriting of an existing file.
/// @return Returns the None output parameter.
IMAGEDEV_CPP_API 
void
writeArrayXi64( std::shared_ptr<iolink::ArrayXi64> inputArrayXi64,
                const std::string& filePath,
                WriteArrayXi64::WriteType writeType,
                bool overwrite );
} // namespace imagedev
