// ================================================================================ //
//       THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),        //
//                  AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                   //
//                                                                                  //
//     REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS      //
//     SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR      //
//                       WRITTEN AUTHORIZATION OF FEI S.A.S.                        //
//                                                                                  //
//                             RESTRICTED RIGHTS LEGEND                             //
//     USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS     //
//     WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN     //
//     SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT     //
//     CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN     //
//        TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.         //
//                                                                                  //
//                         COPYRIGHT (C) 2021 BY FEI S.A.S,                         //
//                                 BORDEAUX, FRANCE                                 //
//                               ALL RIGHTS RESERVED                                //
//                                                                                  //
//        SEE https://developer.openinventor.com/MiscFiles/EULA.pdf FOR MORE        //
// ================================================================================ //

#pragma once

#include <memory>

#include <iolink/IOLinkAPI.h>
#include <iolink/VariantDataValue.h>
#include <iolink/metadata/MetadataNode.h>

namespace iolink
{

/**
 * A factory to build MetadataNode instances.
 */
class IOLINK_API MetadataNodeFactory
{
public:
  MetadataNodeFactory() = delete;
  MetadataNodeFactory(const MetadataNodeFactory& other) = delete;            // copy constructor
  MetadataNodeFactory(MetadataNodeFactory&& other) = delete;                 // move constructor
  MetadataNodeFactory& operator=(const MetadataNodeFactory& other) = delete; // copy assignment
  MetadataNodeFactory& operator=(MetadataNodeFactory&& other) = delete;      // move assignment

  /**
   * To create a metadata node with a key and a value.
   * @param key string to identify the node
   * @param value the VariantDataValue object associated to the node (can be null if no value)
   * @return the created node
   */
  static std::shared_ptr<MetadataNode> create(const std::string& key, std::shared_ptr<VariantDataValue> value);
};

} // end namespace iolink
