// ================================================================================ //
//       THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),        //
//                  AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                   //
//                                                                                  //
//     REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS      //
//     SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR      //
//                       WRITTEN AUTHORIZATION OF FEI S.A.S.                        //
//                                                                                  //
//                             RESTRICTED RIGHTS LEGEND                             //
//     USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS     //
//     WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN     //
//     SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT     //
//     CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN     //
//        TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.         //
//                                                                                  //
//                         COPYRIGHT (C) 2021 BY FEI S.A.S,                         //
//                                 BORDEAUX, FRANCE                                 //
//                               ALL RIGHTS RESERVED                                //
//                                                                                  //
//        SEE https://developer.openinventor.com/MiscFiles/EULA.pdf FOR MORE        //
// ================================================================================ //

#pragma once

#include <memory>

#include <iolink/IOLinkAPI.h>
#include <iolink/metadata/MetadataNode.h>

namespace iolink
{

/**
 * A collection of functions to handle paths on MetadataNode instances.
 */
class IOLINK_API MetadataNodeHelper
{
public:
  /**
   * Helper returning child node of given root node using a path.
   * ex: "/MRC/ext/pixelSize"
   *
   * The following paths are equivalent:
   * "/MRC/ext/pixelSize", "MRC/ext/pixelSize", "\\MRC\\ext\\pixelSize" and "MRC\\ext\\pixelSize"
   *
   * If child node doesn't exist, nullptr is returned.
   *
   * Warning: Doesn't support wildcards or regexp.
   * @param root root of metadata tree to parse
   * @param path path of nodes to follow to access to the searched one
   * @return searched child node if found (nullptr otherwise)
   */
  static std::shared_ptr<const MetadataNode> getNode(std::shared_ptr<const MetadataNode> root, const std::string& path);

  /**
   * Check if a path exists in the metadata tree.
   *
   * @param root The node from which to check the path.
   * @param path The path to test.
   */
  static bool exists(std::shared_ptr<const MetadataNode> root, const std::string& path);

  /**
   * Helper allowing to create the given path in given tree origin.
   * ex: /MRC/ext/pixelSize" or "MRC/ext/pixelSize"
   * The method will only create missing nodes in given tree origin.
   * If specified, the given value will be affected to last node of the given path ("pixelSize" in above example).
   * If the whole path already exists, the last node will be overwritten with a created one containing given value.
   *
   * @param origin node from where the path must be created
   * @param path path to create
   * @param value value to affect to the leaf of given path, null by default
   * @return the origin node
   */
  static std::shared_ptr<const MetadataNode> createPath(std::shared_ptr<MetadataNode> origin,
                                                        const std::string& path,
                                                        std::shared_ptr<VariantDataValue> value);
};

} // end namespace iolink
