// ================================================================================ //
//       THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),        //
//                  AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                   //
//                                                                                  //
//     REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS      //
//     SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR      //
//                       WRITTEN AUTHORIZATION OF FEI S.A.S.                        //
//                                                                                  //
//                             RESTRICTED RIGHTS LEGEND                             //
//     USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS     //
//     WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN     //
//     SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT     //
//     CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN     //
//        TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.         //
//                                                                                  //
//                         COPYRIGHT (C) 2021 BY FEI S.A.S,                         //
//                                 BORDEAUX, FRANCE                                 //
//                               ALL RIGHTS RESERVED                                //
//                                                                                  //
//        SEE https://developer.openinventor.com/MiscFiles/EULA.pdf FOR MORE        //
// ================================================================================ //

#pragma once

#include <memory>

#include <iolink/IOLinkAPI.h>

namespace iolink
{
class MetadataIteratorObject;
class MetadataNode;

/**
 * Class represents an iterator on a list of Metadata nodes.
 */
class IOLINK_API MetadataNodeIterator
{
public:
  MetadataNodeIterator();
  explicit MetadataNodeIterator(MetadataIteratorObject* it);
  MetadataNodeIterator(const MetadataNodeIterator& mit);

  ~MetadataNodeIterator();

  MetadataNodeIterator& operator=(const MetadataNodeIterator& it);

  bool next();
  std::shared_ptr<MetadataNode> value();

  MetadataNodeIterator& operator++();
  MetadataNodeIterator operator++(int);
  bool operator==(const MetadataNodeIterator& rhs) const;
  bool operator!=(const MetadataNodeIterator& rhs) const;
  std::shared_ptr<MetadataNode> operator*();
  std::shared_ptr<MetadataNode> operator->();

private:
  MetadataIteratorObject* m_object;
};

class ConstMetadataIteratorObject;

/**
 * Class represents a const iterator on a list of Metadata nodes.
 */
class IOLINK_API ConstMetadataNodeIterator
{
public:
  ConstMetadataNodeIterator();
  explicit ConstMetadataNodeIterator(ConstMetadataIteratorObject* it);
  ConstMetadataNodeIterator(const ConstMetadataNodeIterator& mit);

  ~ConstMetadataNodeIterator();

  ConstMetadataNodeIterator& operator=(const ConstMetadataNodeIterator& it);

  bool next();
  std::shared_ptr<const MetadataNode> value();

  ConstMetadataNodeIterator& operator++();
  ConstMetadataNodeIterator operator++(int);
  bool operator==(const ConstMetadataNodeIterator& rhs) const;
  bool operator!=(const ConstMetadataNodeIterator& rhs) const;
  std::shared_ptr<const MetadataNode> operator*();
  std::shared_ptr<const MetadataNode> operator->();

private:
  ConstMetadataIteratorObject* m_object;
};

} // namespace iolink
