// ================================================================================ //
//       THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),        //
//                  AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                   //
//                                                                                  //
//     REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS      //
//     SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR      //
//                       WRITTEN AUTHORIZATION OF FEI S.A.S.                        //
//                                                                                  //
//                             RESTRICTED RIGHTS LEGEND                             //
//     USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS     //
//     WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN     //
//     SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT     //
//     CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN     //
//        TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.         //
//                                                                                  //
//                         COPYRIGHT (C) 2021 BY FEI S.A.S,                         //
//                                 BORDEAUX, FRANCE                                 //
//                               ALL RIGHTS RESERVED                                //
//                                                                                  //
//        SEE https://developer.openinventor.com/MiscFiles/EULA.pdf FOR MORE        //
// ================================================================================ //

#pragma once

#include <memory>
#include <string>

#include <iolink/DataType.h>
#include <iolink/IOLinkAPI.h>
#include <iolink/Vector.h>
#include <iolink/view/DataFrameView.h>

namespace iolink
{

class IOLINK_API DataFrameViewFactory
{
public:
  /**
   * This factory is aimed at creating a DataFrame view.
   *
   * @param shape shape of the allocated dataframe (column count, row count)
   * @param columnNames Array which contains the name for each column
   * @param columnDataTypes Array which contains the data type of each column
   *
   * @return an in-memory DataFrameView
   *
   * @warning No check is done on inputs. Pass arguments very carefully.
   * columnNames and columnDataTypes shall have the same element count, and their size
   * must be equal to shape[0].
   * @warning column count and row count cannot be 0. To create an empty dataframe,
   * use the parameterless allocate method.
   */
  static std::shared_ptr<DataFrameView> allocate(const Vector2u64& shape,
                                                 const std::string* columnNames,
                                                 const DataType* columnDataTypes);

  /**
   * This factory aims to create an empty DataFrame view.
   * Columns and rows can be added later.
   */
  static std::shared_ptr<DataFrameView> allocate();
};

} // end namespace iolink
