/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/ImageDevCppExports.h>

#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/Area2dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/BorderPixelCountInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/Area3dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/VolumeFractionInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/BarycenterXInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/BarycenterYInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/BarycenterZInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/Moment2XInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/Moment2YInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/Moment2ZInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/MomentXYInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/MomentXZInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/MomentYZInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/GrayMoment2XInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/GrayMoment2YInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/GrayMoment2ZInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/GrayMomentXYInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/GrayMomentXZInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/GrayMomentYZInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/BoundingBoxOXInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/BoundingBoxOYInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/BoundingBoxOZInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/BoundingBoxDXInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/BoundingBoxDYInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/BoundingBoxDZInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/Breadth2dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/BoundaryPixelCountInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/BorderDistance2dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/Breadth3dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/BreadthOrientationPhi3dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/BreadthOrientationTheta3dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/Thickness3dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/ThicknessOrientationPhi3dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/ThicknessOrientationTheta3dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/EquivalentDiameterInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/Euler2dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/Euler3dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/Eccentricity2dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/Symmetry2dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/FeretDiameter2dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/FeretRatio2dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/FeretInputX2dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/FeretInputY2dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/FeretMean2dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/FeretMean3dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/FeretOutputX2dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/FeretOutputY2dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/FirstPointXInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/FirstPointYInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/FirstPointZInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/GrayBarycenterXInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/GrayBarycenterYInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/GrayBarycenterZInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/IntensityCountInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/FeretMax2dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/FeretMaxOrientation2dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/IntensityMaximumInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/IntensityMeanInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/IntensityMajorityInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/IntensityMedianInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/IntensityMinimumInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/HoleCount2dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/Orientation2dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CroftonPerimeter2dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/InverseCircularity2dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/InverseSphericity3dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/SideLength2dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/IntensityStandardDeviationInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/IntensityIntegralInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/IntensitySquareIntegralInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/Volume3dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/FeretMin2dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/FeretMinOrientation2dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/Rugosity2dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/InsideLength2dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/PolygoneArea2dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/SmoothCircleDifference2dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/EnclosingCircleDifference2dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/ConvexArea2dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/PolygonePerimeter2dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/ConvexPerimeter2dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/PolygoneHoleCount2dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/RectangleCenterX2dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/RectangleCenterY2dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/RectangleLength2dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/RectangleWidth2dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/RectangleOrientation2dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/InsideCenterX2dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/InsideCenterY2dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/NeighborCountInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/PixelCountInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/EnclosingEllipseDifference2dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/Orientation1Theta3dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/Orientation3Theta3dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/Orientation1Phi3dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/Orientation3Phi3dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/Eigenvalue3Info.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/Eigenvalue2Info.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/Eigenvalue1Info.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/Eigenvector3XInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/Eigenvector3YInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/Eigenvector3ZInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/Eigenvector2XInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/Eigenvector2YInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/Eigenvector2ZInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/Eigenvector1XInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/Eigenvector1YInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/Eigenvector1ZInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/ExtentMin3Info.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/ExtentMax3Info.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/ExtentMin2Info.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/ExtentMax2Info.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/ExtentMin1Info.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/ExtentMax1Info.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/AnisotropyInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/ElongationInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/Flatness3dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/GrayEigenvalue3Info.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/GrayEigenvalue2Info.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/GrayEigenvalue1Info.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/GrayEigenvector3XInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/GrayEigenvector3YInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/GrayEigenvector3ZInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/GrayEigenvector2XInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/GrayEigenvector2YInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/GrayEigenvector2ZInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/GrayEigenvector1XInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/GrayEigenvector1YInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/GrayEigenvector1ZInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/GrayExtent3MinInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/GrayExtent3MaxInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/GrayExtent2MinInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/GrayExtent2MaxInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/GrayExtent1MinInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/GrayExtent1MaxInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/GrayAnisotropyInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/GrayElongationInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/GrayFlatness3dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/VoxelFaceArea3dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/FeretMax3dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/FeretMaxOrientationTheta3dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/FeretMaxOrientationPhi3dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/FeretMin3dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/FeretMinOrientationTheta3dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/FeretMinOrientationPhi3dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/FeretRatio3dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/IntegralTotalCurvatureInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/IntegralMeanCurvatureInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceDirXInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceDirYInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrencePixelCountInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceAsmInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceConInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceCorInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceSsvInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceIdmInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceSavInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceSvaInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceSenInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceEntInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceDvaInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceDenInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceIc1Info.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceIc2Info.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceMeanAsmInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceStddevAsmInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceRangeAsmInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceMeanConInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceStddevConInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceRangeConInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceMeanCorInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceStddevCorInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceRangeCorInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceMeanSsvInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceStddevSsvInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceRangeSsvInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceMeanIdmInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceStddevIdmInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceRangeIdmInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceMeanSavInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceStddevSavInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceRangeSavInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceMeanSvaInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceStddevSvaInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceRangeSvaInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceMeanSenInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceStddevSenInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceRangeSenInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceMeanEntInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceStddevEntInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceRangeEntInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceMeanDvaInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceStddevDvaInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceRangeDvaInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceMeanDenInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceStddevDenInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceRangeDenInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceMeanIc1Info.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceStddevIc1Info.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceRangeIc1Info.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceMeanIc2Info.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceStddevIc2Info.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/CooccurrenceRangeIc2Info.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/HistogramMeanInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/HistogramStandardDeviationInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/HistogramVarianceInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/HistogramSkewnessInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/HistogramKurtosisInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/HistogramPeakInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/HistogramQuantile10Info.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/HistogramQuantile25Info.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/HistogramQuantile50Info.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/HistogramQuantile75Info.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/HistogramQuantile90Info.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/HistogramQuantileR1Info.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/HistogramQuantileR2Info.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/HistogramQuantileR3Info.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/HistogramQuantileR4Info.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/HistogramQuantileR5Info.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/HistogramQuantileR6Info.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/FeretMaxInputX3dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/FeretMaxInputY3dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/FeretMaxInputZ3dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/FeretMaxOutputX3dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/FeretMaxOutputY3dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/FeretMaxOutputZ3dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/FeretMinInputX3dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/FeretMinInputY3dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/FeretMinInputZ3dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/FeretMinOutputX3dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/FeretMinOutputY3dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/FeretMinOutputZ3dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/BreadthInputX3dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/BreadthInputY3dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/BreadthInputZ3dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/BreadthOutputX3dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/BreadthOutputY3dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/BreadthOutputZ3dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/ThicknessInputX3dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/ThicknessInputY3dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/ThicknessInputZ3dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/ThicknessOutputX3dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/ThicknessOutputY3dInfo.h>
#include <ImageDev/Data/AnalysisMeasurements/NativeMeasurements/ThicknessOutputZ3dInfo.h>
namespace imagedev
{
class IMAGEDEV_CPP_API NativeMeasurements
{

private:
    static const Area2dInfo theArea2dInfo;
    static const BorderPixelCountInfo theBorderPixelCountInfo;
    static const Area3dInfo theArea3dInfo;
    static const VolumeFractionInfo theVolumeFractionInfo;
    static const BarycenterXInfo theBarycenterXInfo;
    static const BarycenterYInfo theBarycenterYInfo;
    static const BarycenterZInfo theBarycenterZInfo;
    static const Moment2XInfo theMoment2XInfo;
    static const Moment2YInfo theMoment2YInfo;
    static const Moment2ZInfo theMoment2ZInfo;
    static const MomentXYInfo theMomentXYInfo;
    static const MomentXZInfo theMomentXZInfo;
    static const MomentYZInfo theMomentYZInfo;
    static const GrayMoment2XInfo theGrayMoment2XInfo;
    static const GrayMoment2YInfo theGrayMoment2YInfo;
    static const GrayMoment2ZInfo theGrayMoment2ZInfo;
    static const GrayMomentXYInfo theGrayMomentXYInfo;
    static const GrayMomentXZInfo theGrayMomentXZInfo;
    static const GrayMomentYZInfo theGrayMomentYZInfo;
    static const BoundingBoxOXInfo theBoundingBoxOXInfo;
    static const BoundingBoxOYInfo theBoundingBoxOYInfo;
    static const BoundingBoxOZInfo theBoundingBoxOZInfo;
    static const BoundingBoxDXInfo theBoundingBoxDXInfo;
    static const BoundingBoxDYInfo theBoundingBoxDYInfo;
    static const BoundingBoxDZInfo theBoundingBoxDZInfo;
    static const Breadth2dInfo theBreadth2dInfo;
    static const BoundaryPixelCountInfo theBoundaryPixelCountInfo;
    static const BorderDistance2dInfo theBorderDistance2dInfo;
    static const Breadth3dInfo theBreadth3dInfo;
    static const BreadthOrientationPhi3dInfo theBreadthOrientationPhi3dInfo;
    static const BreadthOrientationTheta3dInfo theBreadthOrientationTheta3dInfo;
    static const Thickness3dInfo theThickness3dInfo;
    static const ThicknessOrientationPhi3dInfo theThicknessOrientationPhi3dInfo;
    static const ThicknessOrientationTheta3dInfo theThicknessOrientationTheta3dInfo;
    static const EquivalentDiameterInfo theEquivalentDiameterInfo;
    static const Euler2dInfo theEuler2dInfo;
    static const Euler3dInfo theEuler3dInfo;
    static const Eccentricity2dInfo theEccentricity2dInfo;
    static const Symmetry2dInfo theSymmetry2dInfo;
    static const FeretDiameter2dInfo theFeretDiameter2dInfo;
    static const FeretRatio2dInfo theFeretRatio2dInfo;
    static const FeretInputX2dInfo theFeretInputX2dInfo;
    static const FeretInputY2dInfo theFeretInputY2dInfo;
    static const FeretMean2dInfo theFeretMean2dInfo;
    static const FeretMean3dInfo theFeretMean3dInfo;
    static const FeretOutputX2dInfo theFeretOutputX2dInfo;
    static const FeretOutputY2dInfo theFeretOutputY2dInfo;
    static const FirstPointXInfo theFirstPointXInfo;
    static const FirstPointYInfo theFirstPointYInfo;
    static const FirstPointZInfo theFirstPointZInfo;
    static const GrayBarycenterXInfo theGrayBarycenterXInfo;
    static const GrayBarycenterYInfo theGrayBarycenterYInfo;
    static const GrayBarycenterZInfo theGrayBarycenterZInfo;
    static const IntensityCountInfo theIntensityCountInfo;
    static const FeretMax2dInfo theFeretMax2dInfo;
    static const FeretMaxOrientation2dInfo theFeretMaxOrientation2dInfo;
    static const IntensityMaximumInfo theIntensityMaximumInfo;
    static const IntensityMeanInfo theIntensityMeanInfo;
    static const IntensityMajorityInfo theIntensityMajorityInfo;
    static const IntensityMedianInfo theIntensityMedianInfo;
    static const IntensityMinimumInfo theIntensityMinimumInfo;
    static const HoleCount2dInfo theHoleCount2dInfo;
    static const Orientation2dInfo theOrientation2dInfo;
    static const CroftonPerimeter2dInfo theCroftonPerimeter2dInfo;
    static const InverseCircularity2dInfo theInverseCircularity2dInfo;
    static const InverseSphericity3dInfo theInverseSphericity3dInfo;
    static const SideLength2dInfo theSideLength2dInfo;
    static const IntensityStandardDeviationInfo theIntensityStandardDeviationInfo;
    static const IntensityIntegralInfo theIntensityIntegralInfo;
    static const IntensitySquareIntegralInfo theIntensitySquareIntegralInfo;
    static const Volume3dInfo theVolume3dInfo;
    static const FeretMin2dInfo theFeretMin2dInfo;
    static const FeretMinOrientation2dInfo theFeretMinOrientation2dInfo;
    static const Rugosity2dInfo theRugosity2dInfo;
    static const InsideLength2dInfo theInsideLength2dInfo;
    static const PolygoneArea2dInfo thePolygoneArea2dInfo;
    static const SmoothCircleDifference2dInfo theSmoothCircleDifference2dInfo;
    static const EnclosingCircleDifference2dInfo theEnclosingCircleDifference2dInfo;
    static const ConvexArea2dInfo theConvexArea2dInfo;
    static const PolygonePerimeter2dInfo thePolygonePerimeter2dInfo;
    static const ConvexPerimeter2dInfo theConvexPerimeter2dInfo;
    static const PolygoneHoleCount2dInfo thePolygoneHoleCount2dInfo;
    static const RectangleCenterX2dInfo theRectangleCenterX2dInfo;
    static const RectangleCenterY2dInfo theRectangleCenterY2dInfo;
    static const RectangleLength2dInfo theRectangleLength2dInfo;
    static const RectangleWidth2dInfo theRectangleWidth2dInfo;
    static const RectangleOrientation2dInfo theRectangleOrientation2dInfo;
    static const InsideCenterX2dInfo theInsideCenterX2dInfo;
    static const InsideCenterY2dInfo theInsideCenterY2dInfo;
    static const NeighborCountInfo theNeighborCountInfo;
    static const PixelCountInfo thePixelCountInfo;
    static const EnclosingEllipseDifference2dInfo theEnclosingEllipseDifference2dInfo;
    static const Orientation1Theta3dInfo theOrientation1Theta3dInfo;
    static const Orientation3Theta3dInfo theOrientation3Theta3dInfo;
    static const Orientation1Phi3dInfo theOrientation1Phi3dInfo;
    static const Orientation3Phi3dInfo theOrientation3Phi3dInfo;
    static const Eigenvalue3Info theEigenvalue3Info;
    static const Eigenvalue2Info theEigenvalue2Info;
    static const Eigenvalue1Info theEigenvalue1Info;
    static const Eigenvector3XInfo theEigenvector3XInfo;
    static const Eigenvector3YInfo theEigenvector3YInfo;
    static const Eigenvector3ZInfo theEigenvector3ZInfo;
    static const Eigenvector2XInfo theEigenvector2XInfo;
    static const Eigenvector2YInfo theEigenvector2YInfo;
    static const Eigenvector2ZInfo theEigenvector2ZInfo;
    static const Eigenvector1XInfo theEigenvector1XInfo;
    static const Eigenvector1YInfo theEigenvector1YInfo;
    static const Eigenvector1ZInfo theEigenvector1ZInfo;
    static const ExtentMin3Info theExtentMin3Info;
    static const ExtentMax3Info theExtentMax3Info;
    static const ExtentMin2Info theExtentMin2Info;
    static const ExtentMax2Info theExtentMax2Info;
    static const ExtentMin1Info theExtentMin1Info;
    static const ExtentMax1Info theExtentMax1Info;
    static const AnisotropyInfo theAnisotropyInfo;
    static const ElongationInfo theElongationInfo;
    static const Flatness3dInfo theFlatness3dInfo;
    static const GrayEigenvalue3Info theGrayEigenvalue3Info;
    static const GrayEigenvalue2Info theGrayEigenvalue2Info;
    static const GrayEigenvalue1Info theGrayEigenvalue1Info;
    static const GrayEigenvector3XInfo theGrayEigenvector3XInfo;
    static const GrayEigenvector3YInfo theGrayEigenvector3YInfo;
    static const GrayEigenvector3ZInfo theGrayEigenvector3ZInfo;
    static const GrayEigenvector2XInfo theGrayEigenvector2XInfo;
    static const GrayEigenvector2YInfo theGrayEigenvector2YInfo;
    static const GrayEigenvector2ZInfo theGrayEigenvector2ZInfo;
    static const GrayEigenvector1XInfo theGrayEigenvector1XInfo;
    static const GrayEigenvector1YInfo theGrayEigenvector1YInfo;
    static const GrayEigenvector1ZInfo theGrayEigenvector1ZInfo;
    static const GrayExtent3MinInfo theGrayExtent3MinInfo;
    static const GrayExtent3MaxInfo theGrayExtent3MaxInfo;
    static const GrayExtent2MinInfo theGrayExtent2MinInfo;
    static const GrayExtent2MaxInfo theGrayExtent2MaxInfo;
    static const GrayExtent1MinInfo theGrayExtent1MinInfo;
    static const GrayExtent1MaxInfo theGrayExtent1MaxInfo;
    static const GrayAnisotropyInfo theGrayAnisotropyInfo;
    static const GrayElongationInfo theGrayElongationInfo;
    static const GrayFlatness3dInfo theGrayFlatness3dInfo;
    static const VoxelFaceArea3dInfo theVoxelFaceArea3dInfo;
    static const FeretMax3dInfo theFeretMax3dInfo;
    static const FeretMaxOrientationTheta3dInfo theFeretMaxOrientationTheta3dInfo;
    static const FeretMaxOrientationPhi3dInfo theFeretMaxOrientationPhi3dInfo;
    static const FeretMin3dInfo theFeretMin3dInfo;
    static const FeretMinOrientationTheta3dInfo theFeretMinOrientationTheta3dInfo;
    static const FeretMinOrientationPhi3dInfo theFeretMinOrientationPhi3dInfo;
    static const FeretRatio3dInfo theFeretRatio3dInfo;
    static const IntegralTotalCurvatureInfo theIntegralTotalCurvatureInfo;
    static const IntegralMeanCurvatureInfo theIntegralMeanCurvatureInfo;
    static const CooccurrenceDirXInfo theCooccurrenceDirXInfo;
    static const CooccurrenceDirYInfo theCooccurrenceDirYInfo;
    static const CooccurrencePixelCountInfo theCooccurrencePixelCountInfo;
    static const CooccurrenceAsmInfo theCooccurrenceAsmInfo;
    static const CooccurrenceConInfo theCooccurrenceConInfo;
    static const CooccurrenceCorInfo theCooccurrenceCorInfo;
    static const CooccurrenceSsvInfo theCooccurrenceSsvInfo;
    static const CooccurrenceIdmInfo theCooccurrenceIdmInfo;
    static const CooccurrenceSavInfo theCooccurrenceSavInfo;
    static const CooccurrenceSvaInfo theCooccurrenceSvaInfo;
    static const CooccurrenceSenInfo theCooccurrenceSenInfo;
    static const CooccurrenceEntInfo theCooccurrenceEntInfo;
    static const CooccurrenceDvaInfo theCooccurrenceDvaInfo;
    static const CooccurrenceDenInfo theCooccurrenceDenInfo;
    static const CooccurrenceIc1Info theCooccurrenceIc1Info;
    static const CooccurrenceIc2Info theCooccurrenceIc2Info;
    static const CooccurrenceMeanAsmInfo theCooccurrenceMeanAsmInfo;
    static const CooccurrenceStddevAsmInfo theCooccurrenceStddevAsmInfo;
    static const CooccurrenceRangeAsmInfo theCooccurrenceRangeAsmInfo;
    static const CooccurrenceMeanConInfo theCooccurrenceMeanConInfo;
    static const CooccurrenceStddevConInfo theCooccurrenceStddevConInfo;
    static const CooccurrenceRangeConInfo theCooccurrenceRangeConInfo;
    static const CooccurrenceMeanCorInfo theCooccurrenceMeanCorInfo;
    static const CooccurrenceStddevCorInfo theCooccurrenceStddevCorInfo;
    static const CooccurrenceRangeCorInfo theCooccurrenceRangeCorInfo;
    static const CooccurrenceMeanSsvInfo theCooccurrenceMeanSsvInfo;
    static const CooccurrenceStddevSsvInfo theCooccurrenceStddevSsvInfo;
    static const CooccurrenceRangeSsvInfo theCooccurrenceRangeSsvInfo;
    static const CooccurrenceMeanIdmInfo theCooccurrenceMeanIdmInfo;
    static const CooccurrenceStddevIdmInfo theCooccurrenceStddevIdmInfo;
    static const CooccurrenceRangeIdmInfo theCooccurrenceRangeIdmInfo;
    static const CooccurrenceMeanSavInfo theCooccurrenceMeanSavInfo;
    static const CooccurrenceStddevSavInfo theCooccurrenceStddevSavInfo;
    static const CooccurrenceRangeSavInfo theCooccurrenceRangeSavInfo;
    static const CooccurrenceMeanSvaInfo theCooccurrenceMeanSvaInfo;
    static const CooccurrenceStddevSvaInfo theCooccurrenceStddevSvaInfo;
    static const CooccurrenceRangeSvaInfo theCooccurrenceRangeSvaInfo;
    static const CooccurrenceMeanSenInfo theCooccurrenceMeanSenInfo;
    static const CooccurrenceStddevSenInfo theCooccurrenceStddevSenInfo;
    static const CooccurrenceRangeSenInfo theCooccurrenceRangeSenInfo;
    static const CooccurrenceMeanEntInfo theCooccurrenceMeanEntInfo;
    static const CooccurrenceStddevEntInfo theCooccurrenceStddevEntInfo;
    static const CooccurrenceRangeEntInfo theCooccurrenceRangeEntInfo;
    static const CooccurrenceMeanDvaInfo theCooccurrenceMeanDvaInfo;
    static const CooccurrenceStddevDvaInfo theCooccurrenceStddevDvaInfo;
    static const CooccurrenceRangeDvaInfo theCooccurrenceRangeDvaInfo;
    static const CooccurrenceMeanDenInfo theCooccurrenceMeanDenInfo;
    static const CooccurrenceStddevDenInfo theCooccurrenceStddevDenInfo;
    static const CooccurrenceRangeDenInfo theCooccurrenceRangeDenInfo;
    static const CooccurrenceMeanIc1Info theCooccurrenceMeanIc1Info;
    static const CooccurrenceStddevIc1Info theCooccurrenceStddevIc1Info;
    static const CooccurrenceRangeIc1Info theCooccurrenceRangeIc1Info;
    static const CooccurrenceMeanIc2Info theCooccurrenceMeanIc2Info;
    static const CooccurrenceStddevIc2Info theCooccurrenceStddevIc2Info;
    static const CooccurrenceRangeIc2Info theCooccurrenceRangeIc2Info;
    static const HistogramMeanInfo theHistogramMeanInfo;
    static const HistogramStandardDeviationInfo theHistogramStandardDeviationInfo;
    static const HistogramVarianceInfo theHistogramVarianceInfo;
    static const HistogramSkewnessInfo theHistogramSkewnessInfo;
    static const HistogramKurtosisInfo theHistogramKurtosisInfo;
    static const HistogramPeakInfo theHistogramPeakInfo;
    static const HistogramQuantile10Info theHistogramQuantile10Info;
    static const HistogramQuantile25Info theHistogramQuantile25Info;
    static const HistogramQuantile50Info theHistogramQuantile50Info;
    static const HistogramQuantile75Info theHistogramQuantile75Info;
    static const HistogramQuantile90Info theHistogramQuantile90Info;
    static const HistogramQuantileR1Info theHistogramQuantileR1Info;
    static const HistogramQuantileR2Info theHistogramQuantileR2Info;
    static const HistogramQuantileR3Info theHistogramQuantileR3Info;
    static const HistogramQuantileR4Info theHistogramQuantileR4Info;
    static const HistogramQuantileR5Info theHistogramQuantileR5Info;
    static const HistogramQuantileR6Info theHistogramQuantileR6Info;
    static const FeretMaxInputX3dInfo theFeretMaxInputX3dInfo;
    static const FeretMaxInputY3dInfo theFeretMaxInputY3dInfo;
    static const FeretMaxInputZ3dInfo theFeretMaxInputZ3dInfo;
    static const FeretMaxOutputX3dInfo theFeretMaxOutputX3dInfo;
    static const FeretMaxOutputY3dInfo theFeretMaxOutputY3dInfo;
    static const FeretMaxOutputZ3dInfo theFeretMaxOutputZ3dInfo;
    static const FeretMinInputX3dInfo theFeretMinInputX3dInfo;
    static const FeretMinInputY3dInfo theFeretMinInputY3dInfo;
    static const FeretMinInputZ3dInfo theFeretMinInputZ3dInfo;
    static const FeretMinOutputX3dInfo theFeretMinOutputX3dInfo;
    static const FeretMinOutputY3dInfo theFeretMinOutputY3dInfo;
    static const FeretMinOutputZ3dInfo theFeretMinOutputZ3dInfo;
    static const BreadthInputX3dInfo theBreadthInputX3dInfo;
    static const BreadthInputY3dInfo theBreadthInputY3dInfo;
    static const BreadthInputZ3dInfo theBreadthInputZ3dInfo;
    static const BreadthOutputX3dInfo theBreadthOutputX3dInfo;
    static const BreadthOutputY3dInfo theBreadthOutputY3dInfo;
    static const BreadthOutputZ3dInfo theBreadthOutputZ3dInfo;
    static const ThicknessInputX3dInfo theThicknessInputX3dInfo;
    static const ThicknessInputY3dInfo theThicknessInputY3dInfo;
    static const ThicknessInputZ3dInfo theThicknessInputZ3dInfo;
    static const ThicknessOutputX3dInfo theThicknessOutputX3dInfo;
    static const ThicknessOutputY3dInfo theThicknessOutputY3dInfo;
    static const ThicknessOutputZ3dInfo theThicknessOutputZ3dInfo;
public:
    static const Area2dInfo* area2d;
    static const BorderPixelCountInfo* borderPixelCount;
    static const Area3dInfo* area3d;
    static const VolumeFractionInfo* volumeFraction;
    static const BarycenterXInfo* barycenterX;
    static const BarycenterYInfo* barycenterY;
    static const BarycenterZInfo* barycenterZ;
    static const Moment2XInfo* moment2X;
    static const Moment2YInfo* moment2Y;
    static const Moment2ZInfo* moment2Z;
    static const MomentXYInfo* momentXY;
    static const MomentXZInfo* momentXZ;
    static const MomentYZInfo* momentYZ;
    static const GrayMoment2XInfo* grayMoment2X;
    static const GrayMoment2YInfo* grayMoment2Y;
    static const GrayMoment2ZInfo* grayMoment2Z;
    static const GrayMomentXYInfo* grayMomentXY;
    static const GrayMomentXZInfo* grayMomentXZ;
    static const GrayMomentYZInfo* grayMomentYZ;
    static const BoundingBoxOXInfo* boundingBoxOX;
    static const BoundingBoxOYInfo* boundingBoxOY;
    static const BoundingBoxOZInfo* boundingBoxOZ;
    static const BoundingBoxDXInfo* boundingBoxDX;
    static const BoundingBoxDYInfo* boundingBoxDY;
    static const BoundingBoxDZInfo* boundingBoxDZ;
    static const Breadth2dInfo* breadth2d;
    static const BoundaryPixelCountInfo* boundaryPixelCount;
    static const BorderDistance2dInfo* borderDistance2d;
    static const Breadth3dInfo* breadth3d;
    static const BreadthOrientationPhi3dInfo* breadthOrientationPhi3d;
    static const BreadthOrientationTheta3dInfo* breadthOrientationTheta3d;
    static const Thickness3dInfo* thickness3d;
    static const ThicknessOrientationPhi3dInfo* thicknessOrientationPhi3d;
    static const ThicknessOrientationTheta3dInfo* thicknessOrientationTheta3d;
    static const EquivalentDiameterInfo* equivalentDiameter;
    static const Euler2dInfo* euler2d;
    static const Euler3dInfo* euler3d;
    static const Eccentricity2dInfo* eccentricity2d;
    static const Symmetry2dInfo* symmetry2d;
    static const FeretDiameter2dInfo* feretDiameter2d;
    static const FeretRatio2dInfo* feretRatio2d;
    static const FeretInputX2dInfo* feretInputX2d;
    static const FeretInputY2dInfo* feretInputY2d;
    static const FeretMean2dInfo* feretMean2d;
    static const FeretMean3dInfo* feretMean3d;
    static const FeretOutputX2dInfo* feretOutputX2d;
    static const FeretOutputY2dInfo* feretOutputY2d;
    static const FirstPointXInfo* firstPointX;
    static const FirstPointYInfo* firstPointY;
    static const FirstPointZInfo* firstPointZ;
    static const GrayBarycenterXInfo* grayBarycenterX;
    static const GrayBarycenterYInfo* grayBarycenterY;
    static const GrayBarycenterZInfo* grayBarycenterZ;
    static const IntensityCountInfo* intensityCount;
    static const FeretMax2dInfo* feretMax2d;
    static const FeretMaxOrientation2dInfo* feretMaxOrientation2d;
    static const IntensityMaximumInfo* intensityMaximum;
    static const IntensityMeanInfo* intensityMean;
    static const IntensityMajorityInfo* intensityMajority;
    static const IntensityMedianInfo* intensityMedian;
    static const IntensityMinimumInfo* intensityMinimum;
    static const HoleCount2dInfo* holeCount2d;
    static const Orientation2dInfo* orientation2d;
    static const CroftonPerimeter2dInfo* croftonPerimeter2d;
    static const InverseCircularity2dInfo* inverseCircularity2d;
    static const InverseSphericity3dInfo* inverseSphericity3d;
    static const SideLength2dInfo* sideLength2d;
    static const IntensityStandardDeviationInfo* intensityStandardDeviation;
    static const IntensityIntegralInfo* intensityIntegral;
    static const IntensitySquareIntegralInfo* intensitySquareIntegral;
    static const Volume3dInfo* volume3d;
    static const FeretMin2dInfo* feretMin2d;
    static const FeretMinOrientation2dInfo* feretMinOrientation2d;
    static const Rugosity2dInfo* rugosity2d;
    static const InsideLength2dInfo* insideLength2d;
    static const PolygoneArea2dInfo* polygoneArea2d;
    static const SmoothCircleDifference2dInfo* smoothCircleDifference2d;
    static const EnclosingCircleDifference2dInfo* enclosingCircleDifference2d;
    static const ConvexArea2dInfo* convexArea2d;
    static const PolygonePerimeter2dInfo* polygonePerimeter2d;
    static const ConvexPerimeter2dInfo* convexPerimeter2d;
    static const PolygoneHoleCount2dInfo* polygoneHoleCount2d;
    static const RectangleCenterX2dInfo* rectangleCenterX2d;
    static const RectangleCenterY2dInfo* rectangleCenterY2d;
    static const RectangleLength2dInfo* rectangleLength2d;
    static const RectangleWidth2dInfo* rectangleWidth2d;
    static const RectangleOrientation2dInfo* rectangleOrientation2d;
    static const InsideCenterX2dInfo* insideCenterX2d;
    static const InsideCenterY2dInfo* insideCenterY2d;
    static const NeighborCountInfo* neighborCount;
    static const PixelCountInfo* pixelCount;
    static const EnclosingEllipseDifference2dInfo* enclosingEllipseDifference2d;
    static const Orientation1Theta3dInfo* orientation1Theta3d;
    static const Orientation3Theta3dInfo* orientation3Theta3d;
    static const Orientation1Phi3dInfo* orientation1Phi3d;
    static const Orientation3Phi3dInfo* orientation3Phi3d;
    static const Eigenvalue3Info* eigenvalue3;
    static const Eigenvalue2Info* eigenvalue2;
    static const Eigenvalue1Info* eigenvalue1;
    static const Eigenvector3XInfo* eigenvector3X;
    static const Eigenvector3YInfo* eigenvector3Y;
    static const Eigenvector3ZInfo* eigenvector3Z;
    static const Eigenvector2XInfo* eigenvector2X;
    static const Eigenvector2YInfo* eigenvector2Y;
    static const Eigenvector2ZInfo* eigenvector2Z;
    static const Eigenvector1XInfo* eigenvector1X;
    static const Eigenvector1YInfo* eigenvector1Y;
    static const Eigenvector1ZInfo* eigenvector1Z;
    static const ExtentMin3Info* extentMin3;
    static const ExtentMax3Info* extentMax3;
    static const ExtentMin2Info* extentMin2;
    static const ExtentMax2Info* extentMax2;
    static const ExtentMin1Info* extentMin1;
    static const ExtentMax1Info* extentMax1;
    static const AnisotropyInfo* anisotropy;
    static const ElongationInfo* elongation;
    static const Flatness3dInfo* flatness3d;
    static const GrayEigenvalue3Info* grayEigenvalue3;
    static const GrayEigenvalue2Info* grayEigenvalue2;
    static const GrayEigenvalue1Info* grayEigenvalue1;
    static const GrayEigenvector3XInfo* grayEigenvector3X;
    static const GrayEigenvector3YInfo* grayEigenvector3Y;
    static const GrayEigenvector3ZInfo* grayEigenvector3Z;
    static const GrayEigenvector2XInfo* grayEigenvector2X;
    static const GrayEigenvector2YInfo* grayEigenvector2Y;
    static const GrayEigenvector2ZInfo* grayEigenvector2Z;
    static const GrayEigenvector1XInfo* grayEigenvector1X;
    static const GrayEigenvector1YInfo* grayEigenvector1Y;
    static const GrayEigenvector1ZInfo* grayEigenvector1Z;
    static const GrayExtent3MinInfo* grayExtent3Min;
    static const GrayExtent3MaxInfo* grayExtent3Max;
    static const GrayExtent2MinInfo* grayExtent2Min;
    static const GrayExtent2MaxInfo* grayExtent2Max;
    static const GrayExtent1MinInfo* grayExtent1Min;
    static const GrayExtent1MaxInfo* grayExtent1Max;
    static const GrayAnisotropyInfo* grayAnisotropy;
    static const GrayElongationInfo* grayElongation;
    static const GrayFlatness3dInfo* grayFlatness3d;
    static const VoxelFaceArea3dInfo* voxelFaceArea3d;
    static const FeretMax3dInfo* feretMax3d;
    static const FeretMaxOrientationTheta3dInfo* feretMaxOrientationTheta3d;
    static const FeretMaxOrientationPhi3dInfo* feretMaxOrientationPhi3d;
    static const FeretMin3dInfo* feretMin3d;
    static const FeretMinOrientationTheta3dInfo* feretMinOrientationTheta3d;
    static const FeretMinOrientationPhi3dInfo* feretMinOrientationPhi3d;
    static const FeretRatio3dInfo* feretRatio3d;
    static const IntegralTotalCurvatureInfo* integralTotalCurvature;
    static const IntegralMeanCurvatureInfo* integralMeanCurvature;
    static const CooccurrenceDirXInfo* cooccurrenceDirX;
    static const CooccurrenceDirYInfo* cooccurrenceDirY;
    static const CooccurrencePixelCountInfo* cooccurrencePixelCount;
    static const CooccurrenceAsmInfo* cooccurrenceAsm;
    static const CooccurrenceConInfo* cooccurrenceCon;
    static const CooccurrenceCorInfo* cooccurrenceCor;
    static const CooccurrenceSsvInfo* cooccurrenceSsv;
    static const CooccurrenceIdmInfo* cooccurrenceIdm;
    static const CooccurrenceSavInfo* cooccurrenceSav;
    static const CooccurrenceSvaInfo* cooccurrenceSva;
    static const CooccurrenceSenInfo* cooccurrenceSen;
    static const CooccurrenceEntInfo* cooccurrenceEnt;
    static const CooccurrenceDvaInfo* cooccurrenceDva;
    static const CooccurrenceDenInfo* cooccurrenceDen;
    static const CooccurrenceIc1Info* cooccurrenceIc1;
    static const CooccurrenceIc2Info* cooccurrenceIc2;
    static const CooccurrenceMeanAsmInfo* cooccurrenceMeanAsm;
    static const CooccurrenceStddevAsmInfo* cooccurrenceStddevAsm;
    static const CooccurrenceRangeAsmInfo* cooccurrenceRangeAsm;
    static const CooccurrenceMeanConInfo* cooccurrenceMeanCon;
    static const CooccurrenceStddevConInfo* cooccurrenceStddevCon;
    static const CooccurrenceRangeConInfo* cooccurrenceRangeCon;
    static const CooccurrenceMeanCorInfo* cooccurrenceMeanCor;
    static const CooccurrenceStddevCorInfo* cooccurrenceStddevCor;
    static const CooccurrenceRangeCorInfo* cooccurrenceRangeCor;
    static const CooccurrenceMeanSsvInfo* cooccurrenceMeanSsv;
    static const CooccurrenceStddevSsvInfo* cooccurrenceStddevSsv;
    static const CooccurrenceRangeSsvInfo* cooccurrenceRangeSsv;
    static const CooccurrenceMeanIdmInfo* cooccurrenceMeanIdm;
    static const CooccurrenceStddevIdmInfo* cooccurrenceStddevIdm;
    static const CooccurrenceRangeIdmInfo* cooccurrenceRangeIdm;
    static const CooccurrenceMeanSavInfo* cooccurrenceMeanSav;
    static const CooccurrenceStddevSavInfo* cooccurrenceStddevSav;
    static const CooccurrenceRangeSavInfo* cooccurrenceRangeSav;
    static const CooccurrenceMeanSvaInfo* cooccurrenceMeanSva;
    static const CooccurrenceStddevSvaInfo* cooccurrenceStddevSva;
    static const CooccurrenceRangeSvaInfo* cooccurrenceRangeSva;
    static const CooccurrenceMeanSenInfo* cooccurrenceMeanSen;
    static const CooccurrenceStddevSenInfo* cooccurrenceStddevSen;
    static const CooccurrenceRangeSenInfo* cooccurrenceRangeSen;
    static const CooccurrenceMeanEntInfo* cooccurrenceMeanEnt;
    static const CooccurrenceStddevEntInfo* cooccurrenceStddevEnt;
    static const CooccurrenceRangeEntInfo* cooccurrenceRangeEnt;
    static const CooccurrenceMeanDvaInfo* cooccurrenceMeanDva;
    static const CooccurrenceStddevDvaInfo* cooccurrenceStddevDva;
    static const CooccurrenceRangeDvaInfo* cooccurrenceRangeDva;
    static const CooccurrenceMeanDenInfo* cooccurrenceMeanDen;
    static const CooccurrenceStddevDenInfo* cooccurrenceStddevDen;
    static const CooccurrenceRangeDenInfo* cooccurrenceRangeDen;
    static const CooccurrenceMeanIc1Info* cooccurrenceMeanIc1;
    static const CooccurrenceStddevIc1Info* cooccurrenceStddevIc1;
    static const CooccurrenceRangeIc1Info* cooccurrenceRangeIc1;
    static const CooccurrenceMeanIc2Info* cooccurrenceMeanIc2;
    static const CooccurrenceStddevIc2Info* cooccurrenceStddevIc2;
    static const CooccurrenceRangeIc2Info* cooccurrenceRangeIc2;
    static const HistogramMeanInfo* histogramMean;
    static const HistogramStandardDeviationInfo* histogramStandardDeviation;
    static const HistogramVarianceInfo* histogramVariance;
    static const HistogramSkewnessInfo* histogramSkewness;
    static const HistogramKurtosisInfo* histogramKurtosis;
    static const HistogramPeakInfo* histogramPeak;
    static const HistogramQuantile10Info* histogramQuantile10;
    static const HistogramQuantile25Info* histogramQuantile25;
    static const HistogramQuantile50Info* histogramQuantile50;
    static const HistogramQuantile75Info* histogramQuantile75;
    static const HistogramQuantile90Info* histogramQuantile90;
    static const HistogramQuantileR1Info* histogramQuantileR1;
    static const HistogramQuantileR2Info* histogramQuantileR2;
    static const HistogramQuantileR3Info* histogramQuantileR3;
    static const HistogramQuantileR4Info* histogramQuantileR4;
    static const HistogramQuantileR5Info* histogramQuantileR5;
    static const HistogramQuantileR6Info* histogramQuantileR6;
    static const FeretMaxInputX3dInfo* feretMaxInputX3d;
    static const FeretMaxInputY3dInfo* feretMaxInputY3d;
    static const FeretMaxInputZ3dInfo* feretMaxInputZ3d;
    static const FeretMaxOutputX3dInfo* feretMaxOutputX3d;
    static const FeretMaxOutputY3dInfo* feretMaxOutputY3d;
    static const FeretMaxOutputZ3dInfo* feretMaxOutputZ3d;
    static const FeretMinInputX3dInfo* feretMinInputX3d;
    static const FeretMinInputY3dInfo* feretMinInputY3d;
    static const FeretMinInputZ3dInfo* feretMinInputZ3d;
    static const FeretMinOutputX3dInfo* feretMinOutputX3d;
    static const FeretMinOutputY3dInfo* feretMinOutputY3d;
    static const FeretMinOutputZ3dInfo* feretMinOutputZ3d;
    static const BreadthInputX3dInfo* breadthInputX3d;
    static const BreadthInputY3dInfo* breadthInputY3d;
    static const BreadthInputZ3dInfo* breadthInputZ3d;
    static const BreadthOutputX3dInfo* breadthOutputX3d;
    static const BreadthOutputY3dInfo* breadthOutputY3d;
    static const BreadthOutputZ3dInfo* breadthOutputZ3d;
    static const ThicknessInputX3dInfo* thicknessInputX3d;
    static const ThicknessInputY3dInfo* thicknessInputY3d;
    static const ThicknessInputZ3dInfo* thicknessInputZ3d;
    static const ThicknessOutputX3dInfo* thicknessOutputX3d;
    static const ThicknessOutputY3dInfo* thicknessOutputY3d;
    static const ThicknessOutputZ3dInfo* thicknessOutputZ3d;
    static const std::vector< const MsrInfo* >& all();
};
} // namespace imagedev
