/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/ImageDevCppExports.h>
#include <memory>

namespace imagedev {

class CudaContextPrivate;

/**
 * This class contains information on the CUDA context.
 */
class IMAGEDEV_CPP_API CudaContext final
{
public:
    using Self = CudaContext;
    using Ptr = std::shared_ptr< Self >;

    /**
     *  @brief  Constructor returning a shared_ptr with a CUDA context initialized.
     *
     *  @param  deviceID    Device ID of an NVidia card.
     *  @param  initStream  Indicates if the CUDA stream should be initialized or set to null.
     */
    static Ptr New( int cudaDeviceId = 0, const bool initStream = true );

    /// Gets the device ID
    int cudaDeviceId() const;
    /// Sets the device ID
    /// @param  newCudaDeviceId     Device ID of an NVidia card.
    void setCudaDeviceId( int newCudaDeviceId );

    /// Gets the CUDA stream
    void* cudaStream() const;
    /// Sets the CUDA stream
    /// @param  newCudaStream   New CUDA stream
    void setCudaStream( void* newCudaStream );

    /// Remove the default constructor
    CudaContext() = delete;

    /// Destructor
    ~CudaContext();

    friend CudaContextPrivate;

protected:
    CudaContext( int cudaDeviceId, const bool initStream );

    CudaContextPrivate* m_p = nullptr;
};

} // namespace imagedev
