/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/ImageDevCppExports.h>
#include <iolink/Vector.h>
#include <iolink/view/DataFrameView.h>
#include <ImageDev/Data/MeasurementInformation/FieldInformation.h>
#include <ImageDev/Data/MeasurementInformation/PhysicalDimension.h>
#include <memory>
#include <vector>

namespace object_model
{
class Dictionary;
}

namespace imagedev
{
struct MomentsOfInertia2dMsrPrivate;

/// Contains the features related to the covariance matrix of a two-dimensional image.
/// This object is generated by the imagedev::MomentsOfInertia2d algorithm and the imagedev::momentsOfInertia2d function.
class IMAGEDEV_CPP_API MomentsOfInertia2dMsr
{
public:
    typedef MomentsOfInertia2dMsr Self;
    typedef std::shared_ptr< Self > Ptr;

    /// Default destructor
    ~MomentsOfInertia2dMsr();

    /// Writes the MomentsOfInertia2dMsr measurement into a file defined by a path.
    /// @param pathName Path of a file
    void write( const std::string& pathName ) const;
    /// Reads the MomentsOfInertia2dMsr measurement from a file defined by a path.
    /// @param pathName Path of a file
    /// @return The MomentsOfInertia2dMsr measurement read.
    static MomentsOfInertia2dMsr::Ptr read( const std::string& pathName );

    /// Returns the size of the measurement
    int64_t size() const;

    /// Converts the measurement to an IOLink.DataFrame
    std::shared_ptr< iolink::DataFrameView > toDataFrame() const;

    /// Gets a result of the barycenterX measurement.
    double barycenterX( size_t time = 0 ) const;
    const FieldInformation & barycenterXInformation() const;

    /// Gets a result of the barycenterY measurement.
    double barycenterY( size_t time = 0 ) const;
    const FieldInformation & barycenterYInformation() const;

    /// Gets a result of the momentXX measurement.
    double momentXX( size_t time = 0 ) const;
    const FieldInformation & momentXXInformation() const;

    /// Gets a result of the momentYY measurement.
    double momentYY( size_t time = 0 ) const;
    const FieldInformation & momentYYInformation() const;

    /// Gets a result of the momentXY measurement.
    double momentXY( size_t time = 0 ) const;
    const FieldInformation & momentXYInformation() const;

    /// Gets a result of the orientation measurement.
    double orientation( size_t time = 0 ) const;
    const FieldInformation & orientationInformation() const;

private:
    friend struct MomentsOfInertia2dMsrPrivate;
    MomentsOfInertia2dMsr( object_model::Dictionary* );
    MomentsOfInertia2dMsrPrivate* m_p;
};

} // namespace imagedev
