/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/ImageDevCppExports.h>
#include <iolink/Vector.h>
#include <iolink/view/DataFrameView.h>
#include <ImageDev/Data/MeasurementInformation/FieldInformation.h>
#include <ImageDev/Data/MeasurementInformation/PhysicalDimension.h>
#include <memory>
#include <vector>

namespace object_model
{
class Dictionary;
}

namespace imagedev
{
struct StatisticsMsrPrivate;

/// Contains the statistics computed on the intensities of an image.
/// This object is generated by the imagedev::Statistics algorithm and the imagedev::statistics function.
class IMAGEDEV_CPP_API StatisticsMsr
{
public:
    typedef StatisticsMsr Self;
    typedef std::shared_ptr< Self > Ptr;

    /// Default destructor
    ~StatisticsMsr();

    /// Writes the StatisticsMsr measurement into a file defined by a path.
    /// @param pathName Path of a file
    void write( const std::string& pathName ) const;
    /// Reads the StatisticsMsr measurement from a file defined by a path.
    /// @param pathName Path of a file
    /// @return The StatisticsMsr measurement read.
    static StatisticsMsr::Ptr read( const std::string& pathName );

    /// Returns the size of the measurement
    const iolink::Vector2i64& size() const;

    /// Converts the measurement to an IOLink.DataFrame
    std::shared_ptr< iolink::DataFrameView > toDataFrame() const;

    /// Gets a result of the pixelCount measurement.
    uint64_t pixelCount( size_t channel = 0, size_t time = 0 ) const;
    const FieldInformation & pixelCountInformation() const;

    /// Gets a result of the minimum measurement.
    double minimum( size_t channel = 0, size_t time = 0 ) const;
    const FieldInformation & minimumInformation() const;

    /// Gets a result of the maximum measurement.
    double maximum( size_t channel = 0, size_t time = 0 ) const;
    const FieldInformation & maximumInformation() const;

    /// Gets a result of the intensityRange measurement.
    double intensityRange( size_t channel = 0, size_t time = 0 ) const;
    const FieldInformation & intensityRangeInformation() const;

    /// Gets a result of the mean measurement.
    double mean( size_t channel = 0, size_t time = 0 ) const;
    const FieldInformation & meanInformation() const;

    /// Gets a result of the standardDeviation measurement.
    double standardDeviation( size_t channel = 0, size_t time = 0 ) const;
    const FieldInformation & standardDeviationInformation() const;

    /// Gets a result of the skewness measurement.
    double skewness( size_t channel = 0, size_t time = 0 ) const;
    const FieldInformation & skewnessInformation() const;

    /// Gets a result of the kurtosis measurement.
    double kurtosis( size_t channel = 0, size_t time = 0 ) const;
    const FieldInformation & kurtosisInformation() const;

private:
    friend struct StatisticsMsrPrivate;
    StatisticsMsr( object_model::Dictionary* );
    StatisticsMsrPrivate* m_p;
};

} // namespace imagedev
