/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/

#pragma once

namespace imagedev {

/// An enumerate that gives some physical information about elements stored in an Array
enum class PhysicalInformation
{
    /// No information
    UNKNOWN = 0,
    /// A dimension distance
    LENGTH,
    /// A dimension area
    AREA,
    /// A dimension volume
    VOLUME,
    /// Dimensionless elements representing an angle
    ANGLE,
    /// Elements representing an intensity
    INTENSITY,
    /// Elements representing a square intensity
    SQUARE_INTENSITY,
    /// Element representing a boolean
    BOOLEAN,
    /// Element representing a coordinate
    COORDINATE,
    /// Dimensionless element representing a coefficient
    COEFFICIENT,
    /// Dimensionless element representing a count
    COUNT,
    /// Dimensionless element representing a fraction
    FRACTION,
    /// Dimensionless element representing an index
    INDEX,
    /// Dimensionless element representing a percentage
    PERCENTAGE,
    /// Dimensionless element representing a ratio
    RATIO
};

} // namespace imagedev
