/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/ImageDevCppExports.h>
#include <iolink/Vector.h>
#include <iolink/view/DataFrameView.h>
#include <ImageDev/Data/MeasurementInformation/FieldInformation.h>
#include <ImageDev/Data/MeasurementInformation/PhysicalDimension.h>
#include <memory>
#include <vector>

namespace object_model
{
class Dictionary;
}

namespace imagedev
{
struct OnnxModelPrivate;

/// Contains all the information necessary to run a ONNX command.
/// This object is generated by the imagedev::OnnxMo algorithm and the imagedev::onnxMo function.
class IMAGEDEV_CPP_API OnnxModel
{
public:
    typedef OnnxModel Self;
    typedef std::shared_ptr< Self > Ptr;

    /// Default destructor
    ~OnnxModel();

    /// Writes the OnnxModel measurement into a file defined by a path.
    /// @param pathName Path of a file
    void write( const std::string& pathName ) const;
    /// Reads the OnnxModel measurement from a file defined by a path.
    /// @param pathName Path of a file
    /// @return The OnnxModel measurement read.
    static OnnxModel::Ptr read( const std::string& pathName );

    /// Converts the measurement to an IOLink.DataFrame
    std::shared_ptr< iolink::DataFrameView > toDataFrame() const;

    /// Gets a result of the inputCount measurement.
    uint64_t inputCount(  ) const;
    const FieldInformation & inputCountInformation() const;

    /// Gets a result of the inputDimensionCount measurement.
    uint64_t inputDimensionCount( size_t inputIndex = 0 ) const;
    const FieldInformation & inputDimensionCountInformation() const;

    /// Gets a result of the inputName measurement.
    std::string inputName( size_t inputIndex = 0 ) const;
    const FieldInformation & inputNameInformation() const;

    /// Gets a result of the inputOnnxType measurement.
    std::string inputOnnxType( size_t inputIndex = 0 ) const;
    const FieldInformation & inputOnnxTypeInformation() const;

    /// Gets a result of the inputShape measurement.
    int64_t inputShape( size_t inputIndex = 0, size_t dimension = 0 ) const;
    const FieldInformation & inputShapeInformation() const;

    /// Gets a result of the inputType measurement.
    std::string inputType( size_t inputIndex = 0 ) const;
    const FieldInformation & inputTypeInformation() const;

    /// Gets a result of the outputCount measurement.
    uint64_t outputCount(  ) const;
    const FieldInformation & outputCountInformation() const;

    /// Gets a result of the outputDimensionCount measurement.
    uint64_t outputDimensionCount( size_t outputIndex = 0 ) const;
    const FieldInformation & outputDimensionCountInformation() const;

    /// Gets a result of the outputName measurement.
    std::string outputName( size_t outputIndex = 0 ) const;
    const FieldInformation & outputNameInformation() const;

    /// Gets a result of the outputOnnxType measurement.
    std::string outputOnnxType( size_t outputIndex = 0 ) const;
    const FieldInformation & outputOnnxTypeInformation() const;

    /// Gets a result of the outputShape measurement.
    int64_t outputShape( size_t outputIndex = 0, size_t dimension = 0 ) const;
    const FieldInformation & outputShapeInformation() const;

    /// Gets a result of the outputType measurement.
    std::string outputType( size_t outputIndex = 0 ) const;
    const FieldInformation & outputTypeInformation() const;

    /// Gets a result of the path measurement.
    std::string path(  ) const;
    const FieldInformation & pathInformation() const;

    /// Gets a result of the runnerType measurement.
    std::string runnerType(  ) const;
    const FieldInformation & runnerTypeInformation() const;

private:
    friend struct OnnxModelPrivate;
    OnnxModel( object_model::Dictionary* );
    OnnxModelPrivate* m_p;
};

} // namespace imagedev
