/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/Vector.h>
#include <vector>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Applies a look up table (LUT) on a grayscale image.
class IMAGEDEV_CPP_API ApplyGrayscaleLut final : public GenericAlgorithm
{
public:

    // Command constructor.
    ApplyGrayscaleLut();


    /// Gets the inputImage parameter.
    /// The input grayscale or label image.
    std::shared_ptr< iolink::ImageView > inputImage() const;
    /// Sets the inputImage parameter.
    /// The input grayscale or label image.
    void setInputImage( std::shared_ptr< iolink::ImageView > inputImage );

    /// Gets the anamorphosisLut parameter.
    /// The array of the anamorphosis LUT.
    std::vector<double> anamorphosisLut() const;
    /// Sets the anamorphosisLut parameter.
    /// The array of the anamorphosis LUT.
    void setAnamorphosisLut( const std::vector<double>& anamorphosisLut );

    /// Gets the intensityInputRange parameter.
    /// The index range of the input LUT (minimum and maximum input intensity).
    iolink::Vector2i32 intensityInputRange() const;
    /// Sets the intensityInputRange parameter.
    /// The index range of the input LUT (minimum and maximum input intensity).
    void setIntensityInputRange( const iolink::Vector2i32& intensityInputRange );

    /// Gets the intensityOutputRange parameter.
    /// The low and high outside range level (minimum and maximum output intensity).
    iolink::Vector2i32 intensityOutputRange() const;
    /// Sets the intensityOutputRange parameter.
    /// The low and high outside range level (minimum and maximum output intensity).
    void setIntensityOutputRange( const iolink::Vector2i32& intensityOutputRange );

    /// Gets the outputImage parameter.
    /// The output image. Its dimensions and type are forced to the same values as the input.
    std::shared_ptr< iolink::ImageView > outputImage() const;
    /// Sets the outputImage parameter.
    /// The output image. Its dimensions and type are forced to the same values as the input.
    void setOutputImage( std::shared_ptr< iolink::ImageView > outputImage );

    // Method to launch the command.
    void execute();

};

/// Applies a look up table (LUT) on a grayscale image.
/// @param inputImage The input grayscale or label image.
/// @param anamorphosisLut The array of the anamorphosis LUT.
/// @param intensityInputRange The index range of the input LUT (minimum and maximum input intensity).
/// @param intensityOutputRange The low and high outside range level (minimum and maximum output intensity).
/// @param outputImage The output image. Its dimensions and type are forced to the same values as the input.
/// @return Returns the outputImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
applyGrayscaleLut( std::shared_ptr< iolink::ImageView > inputImage,
                   const std::vector<double>& anamorphosisLut,
                   const iolink::Vector2i32& intensityInputRange,
                   const iolink::Vector2i32& intensityOutputRange,
                   std::shared_ptr< iolink::ImageView > outputImage = nullptr );
} // namespace imagedev
