/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Performs a pointwise arithmetic operation between two images.
class IMAGEDEV_CPP_API ArithmeticOperationWithImage final : public GenericAlgorithm
{
public:
    /// The arithmetic operator to apply.
    enum ArithmeticOperator
    {
    /// The ADD arithmetic operator adds an image to another.
        ADD = 0,
    /// The SUBTRACT arithmetic operator subtract an image from another.
        SUBTRACT,
    /// The MULTIPLY arithmetic operator multiplies an image by another.
        MULTIPLY,
    /// The DIVIDE arithmetic operator divides an image by another.
        DIVIDE,
    /// The MINIMUM arithmetic operator computes the minimum value between two images.
        MINIMUM,
    /// The MAXIMUM arithmetic operator computes the maximum value between two images.
        MAXIMUM
    };

    // Command constructor.
    ArithmeticOperationWithImage();


    /// Gets the inputImage1 parameter.
    /// The first input image.
    std::shared_ptr< iolink::ImageView > inputImage1() const;
    /// Sets the inputImage1 parameter.
    /// The first input image.
    void setInputImage1( std::shared_ptr< iolink::ImageView > inputImage1 );

    /// Gets the inputImage2 parameter.
    /// The second input image, must have same dimensions as the first input.
    std::shared_ptr< iolink::ImageView > inputImage2() const;
    /// Sets the inputImage2 parameter.
    /// The second input image, must have same dimensions as the first input.
    void setInputImage2( std::shared_ptr< iolink::ImageView > inputImage2 );

    /// Gets the arithmeticOperator parameter.
    /// The arithmetic operator to apply.
    ArithmeticOperationWithImage::ArithmeticOperator arithmeticOperator() const;
    /// Sets the arithmeticOperator parameter.
    /// The arithmetic operator to apply.
    void setArithmeticOperator( const ArithmeticOperationWithImage::ArithmeticOperator& arithmeticOperator );

    /// Gets the outputImage parameter.
    /// The output image.
    std::shared_ptr< iolink::ImageView > outputImage() const;
    /// Sets the outputImage parameter.
    /// The output image.
    void setOutputImage( std::shared_ptr< iolink::ImageView > outputImage );

    // Method to launch the command.
    void execute();

};

/// Performs a pointwise arithmetic operation between two images.
/// @param inputImage1 The first input image.
/// @param inputImage2 The second input image, must have same dimensions as the first input.
/// @param arithmeticOperator The arithmetic operator to apply.
/// @param outputImage The output image.
/// @return Returns the outputImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
arithmeticOperationWithImage( std::shared_ptr< iolink::ImageView > inputImage1,
                              std::shared_ptr< iolink::ImageView > inputImage2,
                              ArithmeticOperationWithImage::ArithmeticOperator arithmeticOperator,
                              std::shared_ptr< iolink::ImageView > outputImage = nullptr );
} // namespace imagedev
